/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.enums.TornadoExecutionStatus;
import uk.ac.manchester.tornado.drivers.opencl.OCLCommandQueue;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLCommandExecutionStatus;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLEventInfo;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLProfilingInfo;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLEvent
implements Event {
    private final long[] internalBuffer = new long[2];
    private OCLCommandQueue queue;
    private int localId;
    private long oclEventID;
    private final ByteBuffer buffer = ByteBuffer.allocate(8);
    private String name;
    private int status;
    private TornadoLogger logger;

    OCLEvent() {
        this.buffer.order(OpenCL.BYTE_ORDER);
        this.logger = new TornadoLogger(this.getClass());
    }

    public OCLEvent(String eventNameDescription, OCLCommandQueue queue, int event, long oclEventID) {
        this();
        this.queue = queue;
        this.localId = event;
        this.oclEventID = oclEventID;
        this.name = String.format("%s: 0x", eventNameDescription);
        this.status = -1;
    }

    void setEventId(int localId, long eventId) {
        this.localId = localId;
        this.oclEventID = eventId;
    }

    static native void clGetEventInfo(long var0, int var2, byte[] var3) throws OCLException;

    static native void clGetEventProfilingInfo(long var0, long var2, byte[] var4) throws OCLException;

    static native void clWaitForEvents(long[] var0) throws OCLException;

    static native void clReleaseEvent(long var0) throws OCLException;

    private long readEventTime(OCLProfilingInfo eventType) {
        if (!TornadoOptions.ENABLE_OPENCL_PROFILING) {
            return -1L;
        }
        long time = 0L;
        this.buffer.clear();
        try {
            OCLEvent.clGetEventProfilingInfo(this.oclEventID, eventType.getValue(), this.buffer.array());
            time = this.buffer.getLong();
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
        return time;
    }

    public void waitForEvents(long executionPlanId) {
        try {
            OCLEvent.clWaitForEvents(new long[]{this.oclEventID});
        }
        catch (OCLException e) {
            e.printStackTrace();
        }
    }

    long getCLQueuedTime() {
        return this.readEventTime(OCLProfilingInfo.CL_PROFILING_COMMAND_QUEUED);
    }

    long getCLSubmitTime() {
        return this.readEventTime(OCLProfilingInfo.CL_PROFILING_COMMAND_SUBMIT);
    }

    long getCLStartTime() {
        return this.readEventTime(OCLProfilingInfo.CL_PROFILING_COMMAND_START);
    }

    long getCLEndTime() {
        return this.readEventTime(OCLProfilingInfo.CL_PROFILING_COMMAND_END);
    }

    private OCLCommandExecutionStatus getCLStatus() {
        if (this.status == 0) {
            return OCLCommandExecutionStatus.CL_COMPLETE;
        }
        this.buffer.clear();
        try {
            OCLEvent.clGetEventInfo(this.oclEventID, OCLEventInfo.CL_EVENT_COMMAND_EXECUTION_STATUS.getValue(), this.buffer.array());
            this.status = this.buffer.getInt();
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
        return OCLCommandExecutionStatus.createOCLCommandExecutionStatus(this.status);
    }

    public void waitOn() {
        switch (this.getCLStatus()) {
            case CL_COMPLETE: {
                break;
            }
            case CL_SUBMITTED: {
                this.queue.flush();
            }
            case CL_QUEUED: 
            case CL_RUNNING: {
                this.waitOnPassive();
                break;
            }
            case CL_ERROR: 
            case CL_UNKNOWN: {
                this.logger.fatal("error on event: %s", new Object[]{this.name});
            }
        }
    }

    private void waitOnPassive() {
        try {
            this.internalBuffer[0] = 1L;
            this.internalBuffer[1] = this.oclEventID;
            OCLEvent.clWaitForEvents(this.internalBuffer);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public String toString() {
        return String.format("[OCLEVENT] event: name=%s, status=%s", this.name, this.getStatus());
    }

    public long getOclEventID() {
        return this.oclEventID;
    }

    public String getName() {
        return this.name;
    }

    public TornadoExecutionStatus getStatus() {
        return this.getCLStatus().toTornadoExecutionStatus();
    }

    public long getElapsedTime() {
        return this.getCLEndTime() - this.getCLStartTime();
    }

    public long getDriverDispatchTime() {
        return this.getCLStartTime() - this.getCLQueuedTime();
    }

    public double getElapsedTimeInSeconds() {
        return RuntimeUtilities.elapsedTimeInSeconds((long)this.getCLStartTime(), (long)this.getCLEndTime());
    }

    public double getTotalTimeInSeconds() {
        return this.getElapsedTimeInSeconds();
    }

    public long getQueuedTime() {
        return this.getCLQueuedTime();
    }

    public long getSubmitTime() {
        return this.getCLSubmitTime();
    }

    public long getStartTime() {
        return this.getCLStartTime();
    }

    public long getEndTime() {
        return this.getCLEndTime();
    }

    void release() {
        try {
            OCLEvent.clReleaseEvent(this.oclEventID);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }
}

