/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.drivers.common.TornadoBufferProvider;
import uk.ac.manchester.tornado.drivers.common.power.PowerMetric;
import uk.ac.manchester.tornado.drivers.common.utils.EventDescriptor;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLCodeCache;
import uk.ac.manchester.tornado.drivers.opencl.OCLCommandQueue;
import uk.ac.manchester.tornado.drivers.opencl.OCLCommandQueueTable;
import uk.ac.manchester.tornado.drivers.opencl.OCLContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLEvent;
import uk.ac.manchester.tornado.drivers.opencl.OCLEventPool;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OCLProgram;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMemoryManager;
import uk.ac.manchester.tornado.drivers.opencl.power.OCLEmptyPowerMetricHandler;
import uk.ac.manchester.tornado.drivers.opencl.power.OCLNvidiaPowerMetricHandler;
import uk.ac.manchester.tornado.drivers.opencl.runtime.OCLBufferProvider;
import uk.ac.manchester.tornado.drivers.opencl.runtime.OCLTornadoDevice;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLDeviceContext
implements OCLDeviceContextInterface {
    private final OCLTargetDevice device;
    private final Map<Long, OCLCommandQueueTable> commandQueueTable;
    private final OCLContext context;
    private final PowerMetric powerMetricHandler;
    private final OCLMemoryManager memoryManager;
    private final Map<Long, OCLEventPool> oclEventPool;
    private final TornadoBufferProvider bufferProvider;
    private boolean wasReset;
    private final Set<Long> executionIDs;
    private final Map<Long, OCLCodeCache> codeCache;

    public OCLDeviceContext(OCLTargetDevice device, OCLContext context) {
        this.device = device;
        this.context = context;
        this.memoryManager = new OCLMemoryManager(this);
        this.oclEventPool = new ConcurrentHashMap<Long, OCLEventPool>();
        this.bufferProvider = new OCLBufferProvider(this);
        this.commandQueueTable = new ConcurrentHashMap<Long, OCLCommandQueueTable>();
        this.device.setDeviceContext(this);
        this.executionIDs = Collections.synchronizedSet(new HashSet());
        this.powerMetricHandler = this.isDeviceContextOfNvidia() ? new OCLNvidiaPowerMetricHandler(this) : new OCLEmptyPowerMetricHandler();
        this.codeCache = new ConcurrentHashMap<Long, OCLCodeCache>();
    }

    private boolean isDeviceContextOfNvidia() {
        return this.getPlatformContext().getPlatform().getName().toLowerCase().contains("nvidia");
    }

    public static String checkKernelName(String entryPoint) {
        if (entryPoint.contains("$")) {
            return entryPoint.replace("$", "_");
        }
        return entryPoint;
    }

    @Override
    public OCLTargetDevice getDevice() {
        return this.device;
    }

    public String toString() {
        return String.format("[%d] %s", this.getDevice().getIndex(), this.getDevice().getDeviceName());
    }

    public String getDeviceName() {
        return this.device.getDeviceName();
    }

    public int getDriverIndex() {
        return TornadoRuntimeProvider.getTornadoRuntime().getBackendIndex(OCLBackendImpl.class);
    }

    public Set<Long> getRegisteredPlanIds() {
        return this.executionIDs;
    }

    @Override
    public OCLContext getPlatformContext() {
        return this.context;
    }

    @Override
    public OCLMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public TornadoBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @Override
    public void sync(long executionPlanId) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        if (TornadoOptions.USE_SYNC_FLUSH) {
            commandQueue.flush();
        }
        commandQueue.finish();
    }

    @Override
    public long getDeviceId() {
        return this.device.getDevicePointer();
    }

    @Override
    public int enqueueBarrier(long executionPlanId) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        long oclEvent = commandQueue.enqueueBarrier();
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        return commandQueue.getOpenclVersion() < 120 ? -1 : eventPool.registerEvent(oclEvent, EventDescriptor.DESC_SYNC_BARRIER, commandQueue);
    }

    @Override
    public int enqueueMarker(long executionPlanId) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        long oclEvent = commandQueue.enqueueMarker();
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        return commandQueue.getOpenclVersion() < 120 ? -1 : eventPool.registerEvent(oclEvent, EventDescriptor.DESC_SYNC_MARKER, commandQueue);
    }

    @Override
    public OCLProgram createProgramWithSource(byte[] source, long[] lengths) {
        return this.context.createProgramWithSource(source, lengths, this);
    }

    @Override
    public OCLProgram createProgramWithBinary(byte[] binary, long[] lengths) {
        return this.context.createProgramWithBinary(this.device.getDevicePointer(), binary, lengths, this);
    }

    @Override
    public OCLProgram createProgramWithIL(byte[] spirvBinary, long[] lengths) {
        return this.context.createProgramWithIL(spirvBinary, lengths, this);
    }

    public int enqueueNDRangeKernel(long executionPlanId, OCLKernel kernel, int dim, long[] globalWorkOffset, long[] globalWorkSize, long[] localWorkSize, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueNDRangeKernel(kernel, dim, globalWorkOffset, globalWorkSize, localWorkSize, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_PARALLEL_KERNEL, commandQueue);
    }

    public long getPowerUsage() {
        long[] powerUsage = new long[1];
        this.powerMetricHandler.getPowerUsage(powerUsage);
        return powerUsage[0];
    }

    public ByteOrder getByteOrder() {
        return this.device.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, byte[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_BYTE, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, char[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_BYTE, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, int[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_INT, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, long[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_LONG, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, short[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_SHORT, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, float[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_FLOAT, commandQueue);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long offset, long bytes, double[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_DOUBLE, commandQueue);
    }

    private OCLCommandQueue getCommandQueue(long executionPlanId) {
        this.executionIDs.add(executionPlanId);
        if (!this.commandQueueTable.containsKey(executionPlanId)) {
            OCLTargetDevice device = this.context.devices().get(this.getDeviceIndex());
            OCLCommandQueueTable oclCommandQueueTable = new OCLCommandQueueTable();
            oclCommandQueueTable.get(device, this.context);
            this.commandQueueTable.put(executionPlanId, oclCommandQueueTable);
        }
        return this.commandQueueTable.get(executionPlanId).get(this.context.devices().get(this.getDeviceIndex()), this.context);
    }

    private OCLEventPool getOCLEventPool(long executionPlanId) {
        if (!this.oclEventPool.containsKey(executionPlanId)) {
            OCLEventPool eventPool = new OCLEventPool(TornadoOptions.EVENT_WINDOW);
            this.oclEventPool.put(executionPlanId, eventPool);
        }
        return this.oclEventPool.get(executionPlanId);
    }

    public int enqueueWriteBuffer(long executionPlanId, long bufferId, long deviceOffset, long bytes, long hostPointer, long hostOffset, int[] waitEvents) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        long eventId = commandQueue.enqueueWrite(bufferId, false, deviceOffset, bytes, hostPointer, hostOffset, eventPool.serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null);
        return eventPool.registerEvent(eventId, EventDescriptor.DESC_WRITE_SEGMENT, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, byte[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_BYTE, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, char[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_BYTE, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, int[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_INT, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, long[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_LONG, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, float[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_FLOAT, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, double[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_DOUBLE, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, short[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_SHORT, commandQueue);
    }

    public int enqueueReadBuffer(long executionPlanId, long bufferId, long offset, long bytes, long hostPointer, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, false, offset, bytes, hostPointer, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_SEGMENT, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, byte[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_BYTE, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, char[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_BYTE, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, int[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_INT, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, long[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_LONG, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, short[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_SHORT, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, float[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_FLOAT, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, double[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_DOUBLE, commandQueue);
    }

    public void writeBuffer(long executionPlanId, long bufferId, long offset, long bytes, long hostPointer, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        eventPool.registerEvent(commandQueue.enqueueWrite(bufferId, true, offset, bytes, hostPointer, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_WRITE_SEGMENT, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, byte[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_BYTE, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, char[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_BYTE, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, int[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_INT, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, long[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_LONG, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, float[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_FLOAT, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, double[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_DOUBLE, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, short[] array, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, array, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_SHORT, commandQueue);
    }

    public int readBuffer(long executionPlanId, long bufferId, long offset, long bytes, long hostPointer, long hostOffset, int[] waitEvents) {
        OCLEventPool eventPool;
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return eventPool.registerEvent(commandQueue.enqueueRead(bufferId, true, offset, bytes, hostPointer, hostOffset, (eventPool = this.getOCLEventPool(executionPlanId)).serialiseEvents(waitEvents, commandQueue) ? eventPool.waitEventsBuffer : null), EventDescriptor.DESC_READ_SEGMENT, commandQueue);
    }

    @Override
    public int enqueueBarrier(long executionPlanId, int[] events) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        long oclEvent = commandQueue.enqueueBarrier(eventPool.serialiseEvents(events, commandQueue) ? eventPool.waitEventsBuffer : null);
        return commandQueue.getOpenclVersion() < 120 ? -1 : eventPool.registerEvent(oclEvent, EventDescriptor.DESC_SYNC_BARRIER, commandQueue);
    }

    @Override
    public int enqueueMarker(long executionPlanId, int[] events) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        long oclEvent = commandQueue.enqueueMarker(eventPool.serialiseEvents(events, commandQueue) ? eventPool.waitEventsBuffer : null);
        return commandQueue.getOpenclVersion() < 120 ? -1 : eventPool.registerEvent(oclEvent, EventDescriptor.DESC_SYNC_MARKER, commandQueue);
    }

    @Override
    public void reset(long executionPlanId) {
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        eventPool.reset();
        this.oclEventPool.remove(executionPlanId);
        OCLCommandQueueTable table = this.commandQueueTable.get(executionPlanId);
        if (table != null) {
            table.cleanup(this.device);
            if (table.size() == 0) {
                this.commandQueueTable.remove(executionPlanId);
            }
            this.executionIDs.remove(executionPlanId);
        }
        this.getMemoryManager().releaseKernelStackFrame(executionPlanId);
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        oclCodeCache.reset();
        this.codeCache.remove(executionPlanId);
        this.wasReset = true;
    }

    @Override
    public OCLTornadoDevice toDevice() {
        return new OCLTornadoDevice(this.context.getPlatformIndex(), this.device.getIndex());
    }

    public String getId() {
        return String.format("opencl-%d-%d", this.context.getPlatformIndex(), this.device.getIndex());
    }

    @Override
    public void dumpEvents() {
        Set<Long> executionPlanIds = this.oclEventPool.keySet();
        for (Long id : executionPlanIds) {
            OCLEventPool eventPool = this.getOCLEventPool(id);
            List<OCLEvent> events = eventPool.getEvents();
            String deviceName = "Opencl-" + this.context.getPlatformIndex() + "-" + this.device.getIndex();
            System.out.printf("Found %d events on device %s:\n", events.size(), deviceName);
            if (events.isEmpty()) {
                return;
            }
            events.sort(Comparator.comparingLong(OCLEvent::getCLSubmitTime).thenComparingLong(OCLEvent::getCLStartTime));
            long base = events.getFirst().getCLSubmitTime();
            System.out.println("event: device,type,info,queued,submitted,start,end,status");
            events.forEach(event -> System.out.printf("event: %s,%s,%s,0x%x,%d,%d,%d,%s\n", deviceName, event.getName(), event.getOclEventID(), event.getCLQueuedTime() - base, event.getCLSubmitTime() - base, event.getCLStartTime() - base, event.getCLEndTime() - base, event.getStatus()));
        }
    }

    public boolean wasReset() {
        return this.wasReset;
    }

    public void setResetToFalse() {
        this.wasReset = false;
    }

    public boolean isPlatformFPGA() {
        return this.getDevice().getDeviceType() == OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR && (this.getPlatformContext().getPlatform().getName().toLowerCase().contains("fpga") || this.isPlatformXilinxFPGA());
    }

    public boolean isPlatformXilinxFPGA() {
        return this.getPlatformContext().getPlatform().getName().toLowerCase().contains("xilinx");
    }

    public boolean isFP64Supported() {
        return this.device.isDeviceDoubleFPSupported();
    }

    public int getDeviceIndex() {
        return this.device.getIndex();
    }

    public int getDevicePlatform() {
        return this.context.getPlatformIndex();
    }

    @Override
    public Event resolveEvent(long executionPlanId, int event) {
        if (event == -1) {
            return OCLCommandQueue.EMPTY_EVENT;
        }
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        OCLEventPool eventPool = this.getOCLEventPool(executionPlanId);
        return new OCLEvent(eventPool.getDescriptor(event).getNameDescription(), commandQueue, event, eventPool.getOCLEvent(event));
    }

    @Override
    public void flush(long executionPlanId) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        commandQueue.flush();
    }

    @Override
    public void flushEvents(long executionPlanId) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        commandQueue.flushEvents();
    }

    private OCLCodeCache getOCLCodeCache(long executionPlanId) {
        if (!this.codeCache.containsKey(executionPlanId)) {
            this.codeCache.put(executionPlanId, new OCLCodeCache(this));
        }
        return this.codeCache.get(executionPlanId);
    }

    @Override
    public boolean isKernelAvailable(long executionPlanId) {
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.isKernelAvailable();
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, OCLCompilationResult result) {
        return this.installCode(executionPlanId, result.getMeta(), result.getId(), result.getName(), result.getTargetCode());
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, TaskDataContext meta, String id, String entryPoint, byte[] code) {
        entryPoint = OCLDeviceContext.checkKernelName(entryPoint);
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.installSource(meta, id, entryPoint, code);
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, String id, String entryPoint, byte[] code, boolean printKernel) {
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.installFPGASource(id, entryPoint, code, printKernel);
    }

    @Override
    public boolean isCached(long executionPlanId, String id, String entryPoint) {
        entryPoint = OCLDeviceContext.checkKernelName(entryPoint);
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.isCached(id + "-" + entryPoint);
    }

    public boolean isCached(long executionPlanId, String methodName, SchedulableTask task) {
        methodName = OCLDeviceContext.checkKernelName(methodName);
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.isCached(task.getId() + "-" + methodName);
    }

    @Override
    public OCLInstalledCode getInstalledCode(long executionPlanId, String id, String entryPoint) {
        entryPoint = OCLDeviceContext.checkKernelName(entryPoint);
        OCLCodeCache oclCodeCache = this.getOCLCodeCache(executionPlanId);
        return oclCodeCache.getInstalledCode(id, entryPoint);
    }

    @Override
    public OCLCodeCache getCodeCache(long executionPlanId) {
        return this.getOCLCodeCache(executionPlanId);
    }

    public long mapOnDeviceMemoryRegion(long executionPlanId, long destDevicePtr, long srcDevicePtr, long offset, int sizeOfType, long sizeSource, long sizeDest) {
        OCLCommandQueue commandQueue = this.getCommandQueue(executionPlanId);
        return commandQueue.mapOnDeviceMemoryRegion(commandQueue.getCommandQueuePtr(), destDevicePtr, srcDevicePtr, offset, sizeOfType, sizeSource, sizeDest);
    }
}

