/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceInfo;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLLocalMemType;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLDevice
implements OCLTargetDevice {
    private static final int INIT_VALUE = -1;
    private static final int MAX_BUFFER_SIZE = 8192;
    private final long devicePtr;
    private final int index;
    private final ByteBuffer buffer;
    private String name;
    private int deviceEndianLittle;
    private String openCLVersion;
    private int maxComputeUnits;
    private long maxAllocationSize;
    private long globalMemorySize;
    private long localMemorySize;
    private int maxWorkItemDimensions;
    private long[] maxWorkItemSizes;
    private int maxWorkGroupSize;
    private long maxConstantBufferSize;
    private long doubleFPConfig;
    private long singleFPConfig;
    private int deviceMemoryBaseAlignment;
    private String version;
    private OCLDeviceType deviceType;
    private String deviceVendorName;
    private String driverVersion;
    private String deviceVersion;
    private String deviceExtensions;
    private int deviceMaxClockFrequency;
    private int deviceAddressBits;
    private OCLLocalMemType localMemoryType;
    private int deviceVendorID;
    private OCLDeviceContextInterface deviceContext;
    private float spirvVersion = -1.0f;
    private static final int SPIRV_VERSION_INIT = -1;
    private static final int SPIRV_NOT_SUPPORTED = -2;
    private static final float SPIRV_SUPPPORTED = TornadoOptions.SPIRV_VERSION_SUPPORTED;

    public OCLDevice(int index, long devicePointer) {
        this.index = index;
        this.devicePtr = devicePointer;
        this.buffer = ByteBuffer.allocate(8192);
        this.buffer.order(OpenCL.BYTE_ORDER);
        this.initialValues();
        this.obtainDeviceProperties();
    }

    private void initialValues() {
        this.openCLVersion = null;
        this.deviceEndianLittle = -1;
        this.maxComputeUnits = -1;
        this.maxAllocationSize = -1L;
        this.globalMemorySize = -1L;
        this.localMemorySize = -1L;
        this.maxWorkItemDimensions = -1;
        this.maxWorkGroupSize = -1;
        this.maxConstantBufferSize = -1L;
        this.doubleFPConfig = -1L;
        this.singleFPConfig = -1L;
        this.deviceMemoryBaseAlignment = -1;
        this.maxWorkItemSizes = null;
        this.name = null;
        this.version = null;
        this.deviceType = OCLDeviceType.Unknown;
        this.deviceVendorName = null;
        this.driverVersion = null;
        this.deviceVersion = null;
        this.deviceExtensions = null;
        this.deviceMaxClockFrequency = -1;
        this.deviceAddressBits = -1;
        this.localMemoryType = null;
        this.deviceVendorID = -1;
    }

    private void obtainDeviceProperties() {
        this.getDeviceOpenCLCVersion();
        this.getDeviceEndianLittle();
        this.getDeviceMaxComputeUnits();
        this.getDeviceMaxAllocationSize();
        this.getDeviceGlobalMemorySize();
        this.getDeviceLocalMemorySize();
        this.getDeviceMaxWorkItemDimensions();
        this.getDeviceMaxWorkGroupSize_0();
        this.getDeviceMaxConstantBufferSize();
        this.getDoubleFPConfig();
        this.getDeviceSingleFPConfig();
        this.getDeviceMemoryBaseAlignment();
        this.getDeviceMaxWorkItemSizes();
        this.getDeviceMaxWorkGroupSize();
        this.getDeviceName();
        this.getDeviceType();
        this.getDeviceVendor();
        this.getDriverVersion();
        this.getDeviceVersion();
        this.getDeviceExtensions();
        this.getDeviceMaxClockFrequency();
        this.getDeviceAddressBits();
        this.getDeviceLocalMemoryType();
        this.getDeviceVendorId();
    }

    static native void clGetDeviceInfo(long var0, int var2, byte[] var3);

    @Override
    public long getDevicePointer() {
        return this.devicePtr;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public OCLDeviceType getDeviceType() {
        if (this.deviceType != OCLDeviceType.Unknown) {
            return this.deviceType;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_TYPE.getValue());
        long type = this.buffer.getLong();
        this.deviceType = OCLDeviceType.toDeviceType(type);
        return this.deviceType;
    }

    public int getDeviceVendorId() {
        if (this.deviceVendorID == -1) {
            this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_VENDOR_ID.getValue());
            this.deviceVendorID = this.buffer.getInt();
        }
        return this.deviceVendorID;
    }

    public int getDeviceMemoryBaseAlignment() {
        if (this.deviceMemoryBaseAlignment != -1) {
            return this.deviceMemoryBaseAlignment;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MEM_BASE_ADDR_ALIGN.getValue());
        this.deviceMemoryBaseAlignment = this.buffer.getInt();
        return this.deviceMemoryBaseAlignment;
    }

    @Override
    public boolean isDeviceAvailable() {
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_AVAILABLE.getValue());
        return this.buffer.get() == 1;
    }

    public String getDeviceName() {
        if (this.name == null) {
            this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_NAME.getValue());
            try {
                this.name = new String(this.buffer.array(), "ASCII").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.name = "unknown";
            }
        }
        return this.name;
    }

    @Override
    public String getDeviceVendor() {
        if (this.deviceVendorName != null) {
            return this.deviceVendorName;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_VENDOR.getValue());
        try {
            this.deviceVendorName = new String(this.buffer.array(), "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            this.deviceVendorName = "unknown";
        }
        return this.deviceVendorName;
    }

    @Override
    public String getDriverVersion() {
        if (this.driverVersion != null) {
            return this.driverVersion;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DRIVER_VERSION.getValue());
        try {
            this.driverVersion = new String(this.buffer.array(), "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            this.driverVersion = "unknown";
        }
        return this.driverVersion;
    }

    public String getDeviceVersion() {
        if (this.deviceVersion == null) {
            this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_VERSION.getValue());
            try {
                this.deviceVersion = new String(this.buffer.array(), "ASCII").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.deviceVersion = "unknown";
            }
        }
        return this.deviceVersion;
    }

    @Override
    public String getDeviceOpenCLCVersion() {
        if (this.openCLVersion == null) {
            this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_OPENCL_C_VERSION.getValue());
            try {
                this.openCLVersion = new String(this.buffer.array(), "ASCII").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.openCLVersion = "unknown";
            }
        }
        return this.openCLVersion;
    }

    @Override
    public String getDeviceExtensions() {
        if (this.deviceExtensions != null) {
            return this.deviceExtensions;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_EXTENSIONS.getValue());
        try {
            this.deviceExtensions = new String(this.buffer.array(), "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            this.deviceExtensions = "unknown";
        }
        return this.deviceExtensions;
    }

    public int getDeviceMaxComputeUnits() {
        if (this.maxComputeUnits != -1) {
            return this.maxComputeUnits;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_COMPUTE_UNITS.getValue());
        this.maxComputeUnits = this.buffer.getInt();
        return this.maxComputeUnits;
    }

    public int getDeviceMaxClockFrequency() {
        if (this.deviceMaxClockFrequency != -1) {
            return this.deviceMaxClockFrequency;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_CLOCK_FREQUENCY.getValue());
        this.deviceMaxClockFrequency = this.buffer.getInt();
        return this.deviceMaxClockFrequency;
    }

    public long getDeviceMaxAllocationSize() {
        if (this.maxAllocationSize != -1L) {
            return this.maxAllocationSize;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_MEM_ALLOC_SIZE.getValue());
        this.maxAllocationSize = this.buffer.getLong();
        return this.maxAllocationSize;
    }

    public long getDeviceGlobalMemorySize() {
        if (this.globalMemorySize != -1L) {
            return this.globalMemorySize;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_GLOBAL_MEM_SIZE.getValue());
        this.globalMemorySize = this.buffer.getLong();
        return this.globalMemorySize;
    }

    public long getDeviceLocalMemorySize() {
        if (this.localMemorySize != -1L) {
            return this.localMemorySize;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_LOCAL_MEM_SIZE.getValue());
        this.localMemorySize = this.buffer.getLong();
        return this.localMemorySize;
    }

    public int getDeviceMaxWorkItemDimensions() {
        if (this.maxWorkItemDimensions != -1) {
            return this.maxWorkItemDimensions;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS.getValue());
        this.maxWorkItemDimensions = this.buffer.getInt();
        return this.maxWorkItemDimensions;
    }

    public long[] getDeviceMaxWorkItemSizes() {
        if (this.maxWorkItemSizes != null) {
            return this.maxWorkItemSizes;
        }
        int elements = this.getDeviceMaxWorkItemDimensions();
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_WORK_ITEM_SIZES.getValue());
        this.buffer.rewind();
        this.maxWorkItemSizes = new long[elements];
        for (int i = 0; i < elements; ++i) {
            this.maxWorkItemSizes[i] = this.buffer.getLong();
        }
        return this.maxWorkItemSizes;
    }

    private int getDeviceMaxWorkGroupSize_0() {
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_WORK_GROUP_SIZE.getValue());
        this.maxWorkGroupSize = this.buffer.getInt();
        return this.maxWorkGroupSize;
    }

    public long[] getDeviceMaxWorkGroupSize() {
        if (this.maxWorkGroupSize != -1) {
            return new long[]{this.maxWorkGroupSize};
        }
        this.maxWorkGroupSize = this.getDeviceMaxWorkGroupSize_0();
        return new long[]{this.maxWorkGroupSize};
    }

    public int getMaxThreadsPerBlock() {
        return this.maxWorkGroupSize;
    }

    public long getDeviceMaxConstantBufferSize() {
        if (this.maxConstantBufferSize != -1L) {
            return this.maxConstantBufferSize;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE.getValue());
        this.maxConstantBufferSize = this.buffer.getLong();
        return this.maxConstantBufferSize;
    }

    private long getDoubleFPConfig() {
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_DOUBLE_FP_CONFIG.getValue());
        return this.buffer.getLong();
    }

    @Override
    public boolean isDeviceDoubleFPSupported() {
        if (this.doubleFPConfig != -1L) {
            return this.doubleFPConfig != 0L;
        }
        this.doubleFPConfig = this.getDoubleFPConfig();
        return this.doubleFPConfig != 0L;
    }

    public long getDeviceSingleFPConfig() {
        if (this.singleFPConfig != -1L) {
            return this.singleFPConfig;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_SINGLE_FP_CONFIG.getValue());
        this.singleFPConfig = this.buffer.getLong();
        return this.singleFPConfig;
    }

    public int getDeviceAddressBits() {
        if (this.deviceAddressBits != -1) {
            return this.deviceAddressBits;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_ADDRESS_BITS.getValue());
        this.deviceAddressBits = this.buffer.getInt();
        return this.deviceAddressBits;
    }

    public boolean hasDeviceUnifiedMemory() {
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_HOST_UNIFIED_MEMORY.getValue());
        return this.buffer.getInt() == 1;
    }

    public OCLLocalMemType getDeviceLocalMemoryType() {
        if (this.localMemoryType != null) {
            return this.localMemoryType;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_LOCAL_MEM_TYPE.getValue());
        this.localMemoryType = OCLLocalMemType.toLocalMemType(this.buffer.getInt());
        return this.localMemoryType;
    }

    private int getDeviceEndianLittle() {
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_ENDIAN_LITTLE.getValue());
        this.deviceEndianLittle = this.buffer.getInt();
        return this.deviceEndianLittle;
    }

    @Override
    public boolean isLittleEndian() {
        if (this.deviceEndianLittle != -1) {
            return this.deviceEndianLittle == 1;
        }
        this.getDeviceEndianLittle();
        return this.deviceEndianLittle == 1;
    }

    @Override
    public OCLDeviceContextInterface getDeviceContext() {
        return this.deviceContext;
    }

    @Override
    public void setDeviceContext(OCLDeviceContextInterface deviceContext) {
        this.deviceContext = deviceContext;
    }

    @Override
    public int deviceVersion() {
        return Integer.parseInt(this.getVersion().split(" ")[1].replace(".", "")) * 10;
    }

    @Override
    public boolean isSPIRVSupported() {
        String[] spirvVersions;
        if (this.spirvVersion == -2.0f) {
            return false;
        }
        if (this.spirvVersion > 0.0f) {
            return this.spirvVersion >= SPIRV_SUPPPORTED;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_IL_VERSION.getValue());
        String versionQuery = new String(this.buffer.array(), StandardCharsets.US_ASCII);
        if (versionQuery.isEmpty()) {
            return false;
        }
        for (String version : spirvVersions = versionQuery.trim().split(" ")) {
            if (version.isEmpty()) continue;
            String v = version.split("_")[1];
            try {
                this.spirvVersion = Float.parseFloat(v);
                return this.spirvVersion >= SPIRV_SUPPPORTED;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.spirvVersion = -2.0f;
        return false;
    }

    @Override
    public int getWordSize() {
        return this.getDeviceAddressBits() >> 3;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.queryOpenCLAPI(OCLDeviceInfo.CL_DEVICE_VERSION.getValue());
        try {
            this.version = new String(this.buffer.array(), "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            this.version = "OpenCL 0.0";
        }
        return this.version;
    }

    private void queryOpenCLAPI(int value) {
        Arrays.fill(this.buffer.array(), (byte)0);
        this.buffer.clear();
        OCLDevice.clGetDeviceInfo(this.devicePtr, value, this.buffer.array());
    }

    public String toString() {
        return String.format("id=0x%x, deviceName=%s, type=%s, available=%s", this.devicePtr, this.getDeviceName(), this.getDeviceType().toString(), this.isDeviceAvailable());
    }

    public String getDeviceInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("id=0x%x, deviceName=%s, type=%s, available=%s\n", this.devicePtr, this.getDeviceName(), this.getDeviceType().toString(), this.isDeviceAvailable()));
        sb.append(String.format("Freq=%s, max compute units=%d\n", RuntimeUtilities.humanReadableFreq((int)this.getDeviceMaxClockFrequency()), this.getDeviceMaxComputeUnits()));
        sb.append(String.format("Global mem. size=%s, local mem. size=%s\n", RuntimeUtilities.humanReadableByteCount((long)this.getDeviceGlobalMemorySize(), (boolean)false), RuntimeUtilities.humanReadableByteCount((long)this.getDeviceLocalMemorySize(), (boolean)false)));
        sb.append(String.format("Extensions:\n", new Object[0]));
        for (String extension : this.getDeviceExtensions().split(" ")) {
            sb.append("\t" + extension + "\n");
        }
        sb.append(String.format("Unified memory   : %s\n", this.hasDeviceUnifiedMemory()));
        sb.append(String.format("Device vendor    : %s\n", this.getDeviceVendor()));
        sb.append(String.format("Device version   : %s\n", this.getDeviceVersion()));
        sb.append(String.format("Driver version   : %s\n", this.getDriverVersion()));
        sb.append(String.format("OpenCL C version : %s\n", this.getDeviceOpenCLCVersion()));
        sb.append(String.format("Endianness       : %s\n", this.isLittleEndian() ? "little" : "big"));
        sb.append(String.format("Address size     : %d\n", this.getDeviceAddressBits()));
        sb.append(String.format("Single fp config : %b\n", this.getDeviceSingleFPConfig()));
        sb.append(String.format("Double fp config : %b\n", this.isDeviceDoubleFPSupported()));
        return sb.toString();
    }
}

