/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.tornado.api.exceptions.TornadoNoOpenCLPlatformException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLPlatform;
import uk.ac.manchester.tornado.drivers.opencl.OCLProgram;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLContext
implements OCLContextInterface {
    private final long contextID;
    private final List<OCLTargetDevice> devices;
    private final List<OCLDeviceContext> deviceContexts;
    private final OCLPlatform platform;
    private final TornadoLogger logger;

    public OCLContext(OCLPlatform platform, long contextPointer, List<OCLTargetDevice> devices) {
        this.platform = platform;
        this.contextID = contextPointer;
        this.devices = devices;
        this.deviceContexts = new ArrayList<OCLDeviceContext>(devices.size());
        this.logger = new TornadoLogger(this.getClass());
    }

    native void clReleaseContext(long var1) throws OCLException;

    native void clGetContextInfo(long var1, int var3, byte[] var4) throws OCLException;

    public native long clCreateCommandQueue(long var1, long var3, long var5) throws OCLException;

    native long allocateOffHeapMemory(long var1, long var3);

    native void freeOffHeapMemory(long var1);

    native ByteBuffer asByteBuffer(long var1, long var3);

    native OCLBufferResult createBuffer(long var1, long var3, long var5, long var7) throws OCLException;

    native long createSubBuffer(long var1, long var3, int var5, byte[] var6) throws OCLException;

    native void clReleaseMemObject(long var1) throws OCLException;

    native long clCreateProgramWithSource(long var1, byte[] var3, long[] var4) throws OCLException;

    native long clCreateProgramWithBinary(long var1, long var3, byte[] var5, long[] var6) throws OCLException;

    native long clCreateProgramWithIL(long var1, byte[] var3, long[] var4) throws OCLException;

    @Override
    public int getNumDevices() {
        return this.devices.size();
    }

    @Override
    public List<OCLTargetDevice> devices() {
        return this.devices;
    }

    @Override
    public long getContextId() {
        return this.contextID;
    }

    private void createCommandQueue(int index, long properties) {
        OCLTargetDevice device = this.devices.get(index);
        try {
            int platformVersion = Integer.parseInt(this.platform.getVersion().split(" ")[1].replace(".", "")) * 10;
            int deviceVersion = Integer.parseInt(device.getVersion().split(" ")[1].replace(".", "")) * 10;
            this.logger.info("platform: version=%s (%s) on %s", new Object[]{platformVersion, this.platform.getVersion(), device.getDeviceName()});
            this.logger.info("device  : version=%s (%s) on %s", new Object[]{deviceVersion, device.getVersion(), device.getDeviceName()});
            this.clCreateCommandQueue(this.contextID, device.getDevicePointer(), properties);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoRuntimeException("[ERROR] OpenCL Command Queue Initialization not valid");
        }
    }

    public long getProperties() {
        long properties = 0L;
        if (TornadoOptions.ENABLE_OPENCL_PROFILING) {
            properties |= 2L;
        }
        if (TornadoOptions.ENABLE_OOO_EXECUTION) {
            properties |= 1L;
        }
        return properties;
    }

    @Override
    public void createCommandQueue(int index) {
        long properties = this.getProperties();
        this.createCommandQueue(index, properties);
    }

    public OCLProgram createProgramWithSource(byte[] source, long[] lengths, OCLDeviceContext deviceContext) {
        OCLProgram program = null;
        try {
            program = new OCLProgram(this.clCreateProgramWithSource(this.contextID, source, lengths), deviceContext);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
        return program;
    }

    public OCLProgram createProgramWithIL(byte[] spirvBinary, long[] lengths, OCLDeviceContext deviceContext) {
        OCLProgram program;
        try {
            long programID = this.clCreateProgramWithIL(this.contextID, spirvBinary, lengths);
            if (programID == -1L) {
                throw new TornadoNoOpenCLPlatformException("OpenCL version <= 2.1. clCreateProgramWithIL is not supported");
            }
            program = new OCLProgram(programID, deviceContext);
        }
        catch (OCLException e) {
            throw new TornadoRuntimeException((Exception)e);
        }
        return program;
    }

    public OCLProgram createProgramWithBinary(long deviceId, byte[] binary, long[] lengths, OCLDeviceContext deviceContext) {
        OCLProgram program = null;
        try {
            program = new OCLProgram(this.clCreateProgramWithBinary(this.contextID, deviceId, binary, lengths), deviceContext);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
        return program;
    }

    public void cleanup() {
        if (TornadoOptions.DUMP_EVENTS) {
            for (OCLDeviceContext deviceContext : this.deviceContexts) {
                deviceContext.dumpEvents();
            }
        }
        try {
            long t1 = System.nanoTime();
            this.clReleaseContext(this.contextID);
            long t2 = System.nanoTime();
            if (TornadoOptions.FULL_DEBUG) {
                System.out.printf("cleanup: %-10s..........%.9f s%n", "context", (double)(t2 - t1) * 1.0E-9);
            }
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoRuntimeException(e.getMessage());
        }
    }

    public String toString() {
        return String.format("id=0x%x, device count=%d", this.contextID, this.getNumDevices());
    }

    @Override
    public OCLDeviceContext createDeviceContext(int index) {
        this.logger.debug("creating device context for device: %s", new Object[]{this.devices.get(index).toString()});
        this.createCommandQueue(index);
        OCLDeviceContext deviceContext = new OCLDeviceContext(this.devices.get(index), this);
        this.deviceContexts.add(deviceContext);
        return deviceContext;
    }

    public OCLBufferResult createBuffer(long flags, long bytes) {
        return this.createBuffer(flags, bytes, 0L);
    }

    private OCLBufferResult createBuffer(long flags, long bytes, long hostPointer) {
        try {
            OCLBufferResult result = this.createBuffer(this.contextID, flags, bytes, hostPointer);
            this.logger.info("buffer allocated %s @ 0x%x", new Object[]{RuntimeUtilities.humanReadableByteCount((long)bytes, (boolean)false), result.getBuffer()});
            return result;
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void releaseBuffer(long bufferId) {
        try {
            this.clReleaseMemObject(bufferId);
            this.logger.info("buffer released 0x%x", new Object[]{bufferId});
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public int getPlatformIndex() {
        return this.platform.getIndex();
    }

    @Override
    public OCLPlatform getPlatform() {
        return this.platform;
    }

    public static class OCLBufferResult {
        private final long oclBuffer;
        private final long address;
        private final int result;

        public OCLBufferResult(long oclBuffer, long address, int result) {
            this.oclBuffer = oclBuffer;
            this.address = address;
            this.result = result;
        }

        public long getBuffer() {
            return this.oclBuffer;
        }

        public long getAddress() {
            return this.address;
        }

        public int getResult() {
            return this.result;
        }
    }
}

