/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLCommandQueue;
import uk.ac.manchester.tornado.drivers.opencl.OCLContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;

public class OCLCommandQueueTable {
    private final Map<OCLTargetDevice, ThreadCommandQueueTable> deviceCommandMap = new ConcurrentHashMap<OCLTargetDevice, ThreadCommandQueueTable>();

    public OCLCommandQueue get(OCLTargetDevice device, OCLContext context) {
        if (!this.deviceCommandMap.containsKey(device)) {
            ThreadCommandQueueTable table = new ThreadCommandQueueTable();
            table.get(Thread.currentThread().threadId(), device, context);
            this.deviceCommandMap.put(device, table);
        }
        return this.deviceCommandMap.get(device).get(Thread.currentThread().threadId(), device, context);
    }

    public void cleanup(OCLTargetDevice device) {
        if (this.deviceCommandMap.containsKey(device)) {
            this.deviceCommandMap.get(device).cleanup(Thread.currentThread().threadId());
        }
        if (this.deviceCommandMap.get(device).size() == 0) {
            this.deviceCommandMap.remove(device);
        }
    }

    public int size() {
        return this.deviceCommandMap.size();
    }

    private static class ThreadCommandQueueTable {
        private final Map<Long, OCLCommandQueue> commandQueueMap = new ConcurrentHashMap<Long, OCLCommandQueue>();

        ThreadCommandQueueTable() {
        }

        public OCLCommandQueue get(long threadId, OCLTargetDevice device, OCLContext context) {
            if (!this.commandQueueMap.containsKey(threadId)) {
                long commandQueuePtr;
                int deviceVersion = device.deviceVersion();
                long commandProperties = context.getProperties();
                try {
                    commandQueuePtr = context.clCreateCommandQueue(context.getContextId(), device.getDevicePointer(), commandProperties);
                }
                catch (OCLException e) {
                    throw new TornadoRuntimeException((Exception)e);
                }
                OCLCommandQueue commandQueue = new OCLCommandQueue(commandQueuePtr, commandProperties, deviceVersion);
                this.commandQueueMap.put(threadId, commandQueue);
            }
            return this.commandQueueMap.get(threadId);
        }

        public void cleanup(long threadId) {
            if (this.commandQueueMap.containsKey(threadId)) {
                OCLCommandQueue queue = this.commandQueueMap.remove(threadId);
                queue.cleanup();
            }
        }

        public int size() {
            return this.commandQueueMap.size();
        }
    }
}

