/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.nio.ByteBuffer;
import jdk.vm.ci.meta.JavaKind;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.drivers.common.CommandQueue;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLCommandQueueInfo;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.drivers.opencl.natives.NativeCommandQueue;
import uk.ac.manchester.tornado.runtime.EmptyEvent;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class OCLCommandQueue
extends CommandQueue {
    protected static final Event EMPTY_EVENT = new EmptyEvent();
    private TornadoLogger logger = new TornadoLogger(((Object)((Object)this)).getClass());
    private final long commandQueuePtr;
    private final ByteBuffer buffer;
    private final long properties;
    private final int openclVersion;

    public OCLCommandQueue(long commandQueuePtr, long properties, int version) {
        this.commandQueuePtr = commandQueuePtr;
        this.properties = properties;
        this.buffer = ByteBuffer.allocate(128);
        this.buffer.order(OpenCL.BYTE_ORDER);
        this.openclVersion = version;
    }

    public long getCommandQueuePtr() {
        return this.commandQueuePtr;
    }

    static native void clReleaseCommandQueue(long var0) throws OCLException;

    static native void clGetCommandQueueInfo(long var0, int var2, byte[] var3) throws OCLException;

    static native long clEnqueueNDRangeKernel(long var0, long var2, int var4, long[] var5, long[] var6, long[] var7, long[] var8) throws OCLException;

    static native long writeArrayToDevice(long var0, byte[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, char[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, short[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, int[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, long[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, float[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, double[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long writeArrayToDevice(long var0, long var2, long var4, boolean var6, long var7, long var9, long var11, long[] var13) throws OCLException;

    static native long readArrayFromDevice(long var0, byte[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, char[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, short[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, int[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, long[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, float[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDevice(long var0, double[] var2, long var3, boolean var5, long var6, long var8, long var10, long[] var12) throws OCLException;

    static native long readArrayFromDeviceOffHeap(long var0, long var2, long var4, boolean var6, long var7, long var9, long var11, long[] var13) throws OCLException;

    static native void clEnqueueWaitForEvents(long var0, long[] var2) throws OCLException;

    static native long clEnqueueMarkerWithWaitList(long var0, long[] var2) throws OCLException;

    static native long clEnqueueBarrierWithWaitList(long var0, long[] var2) throws OCLException;

    static native void clFlush(long var0) throws OCLException;

    static native void clFinish(long var0) throws OCLException;

    public void flushEvents() {
        try {
            OCLCommandQueue.clFlush(this.commandQueuePtr);
        }
        catch (OCLException e) {
            e.printStackTrace();
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long getContextId() {
        long result;
        this.buffer.clear();
        try {
            OCLCommandQueue.clGetCommandQueueInfo(this.commandQueuePtr, OCLCommandQueueInfo.CL_QUEUE_CONTEXT.getValue(), this.buffer.array());
            result = this.buffer.getLong();
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public long getDeviceId() {
        long result;
        this.buffer.clear();
        try {
            OCLCommandQueue.clGetCommandQueueInfo(this.commandQueuePtr, OCLCommandQueueInfo.CL_QUEUE_DEVICE.getValue(), this.buffer.array());
            result = this.buffer.getLong();
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return result;
    }

    public long getProperties() {
        return this.properties;
    }

    public long enqueueBarrier() {
        return this.enqueueBarrier(null);
    }

    public long enqueueMarker() {
        return this.enqueueMarker(null);
    }

    public void cleanup() {
        try {
            OCLCommandQueue.clReleaseCommandQueue(this.commandQueuePtr);
        }
        catch (OCLException e) {
            e.printStackTrace();
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public String toString() {
        return String.format("Queue: context=0x%x, device=0x%x", this.getContextId(), this.getDeviceId());
    }

    public long enqueueNDRangeKernel(OCLKernel kernel, int dim, long[] globalWorkOffset, long[] globalWorkSize, long[] localWorkSize, long[] waitEvents) {
        try {
            return OCLCommandQueue.clEnqueueNDRangeKernel(this.commandQueuePtr, kernel.getOclKernelID(), dim, (long[])(this.openclVersion > 100 ? globalWorkOffset : null), globalWorkSize, localWorkSize, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, byte[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, char[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, int[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, short[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, long[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, float[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, double[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueWrite(long devicePtr, boolean blocking, long offset, long bytes, long hostPointer, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((hostPointer != 0L ? 1 : 0) != 0, (String)"null segment", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.writeArrayToDevice(this.commandQueuePtr, hostPointer, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, byte[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, char[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, int[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"null array", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, short[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"array is null", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, long[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"array is null", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, float[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"array is null", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, double[] array, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((array != null ? 1 : 0) != 0, (String)"array is null", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDevice(this.commandQueuePtr, array, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueRead(long devicePtr, boolean blocking, long offset, long bytes, long hostPointer, long hostOffset, long[] waitEvents) {
        TornadoInternalError.guarantee((hostPointer != 0L ? 1 : 0) != 0, (String)"segment is null", (Object[])new Object[0]);
        try {
            return OCLCommandQueue.readArrayFromDeviceOffHeap(this.commandQueuePtr, hostPointer, hostOffset, blocking, offset, bytes, devicePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public void finish() {
        try {
            OCLCommandQueue.clFinish(this.commandQueuePtr);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public void flush() {
        try {
            OCLCommandQueue.clFlush(this.commandQueuePtr);
        }
        catch (OCLException e) {
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueBarrier(long[] waitEvents) {
        return this.openclVersion < 120 ? (long)this.enqueueBarrier_OCLv1_1(waitEvents) : this.enqueueBarrier_OCLv1_2(waitEvents);
    }

    private int enqueueBarrier_OCLv1_1(long[] events) {
        try {
            if (events != null) {
                OCLCommandQueue.clEnqueueWaitForEvents(this.commandQueuePtr, events);
            }
        }
        catch (OCLException e) {
            this.logger.fatal(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return 0;
    }

    private long enqueueBarrier_OCLv1_2(long[] waitEvents) {
        try {
            return OCLCommandQueue.clEnqueueBarrierWithWaitList(this.commandQueuePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.fatal(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public long enqueueMarker(long[] waitEvents) {
        return this.openclVersion < 120 ? (long)this.enqueueMarker11(waitEvents) : this.enqueueMarker12(waitEvents);
    }

    private int enqueueMarker11(long[] events) {
        return this.enqueueBarrier_OCLv1_1(events);
    }

    private long enqueueMarker12(long[] waitEvents) {
        try {
            return OCLCommandQueue.clEnqueueMarkerWithWaitList(this.commandQueuePtr, waitEvents);
        }
        catch (OCLException e) {
            this.logger.fatal(e.getMessage());
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
    }

    public int getOpenclVersion() {
        return this.openclVersion;
    }

    public long mapOnDeviceMemoryRegion(long commandQueuePtr, long destDevicePtr, long srcDevicePtr, long offset, int sizeOfType, long sizeSource, long sizeDest) {
        long ptr;
        if (offset == 0L) {
            ptr = NativeCommandQueue.mapOnDeviceMemoryRegion(destDevicePtr, srcDevicePtr);
        } else {
            long headerSize = TornadoNativeArray.ARRAY_HEADER / (long)JavaKind.Int.getByteCount();
            ptr = NativeCommandQueue.mapOnDeviceMemoryNDRegion(commandQueuePtr, destDevicePtr, srcDevicePtr, offset, sizeOfType, headerSize, sizeSource, sizeDest);
        }
        return ptr;
    }
}

