/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoCompilationException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OCLProgram;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLBuildStatus;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.Tornado;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLCodeCache {
    private static final String FALSE = "False";
    private static final int SPIRV_MAGIC_NUMBER = 119734787;
    private static final String OPENCL_SOURCE_SUFFIX = ".cl";
    private final boolean OPENCL_CACHE_ENABLE = Boolean.parseBoolean(Tornado.getProperty((String)"tornado.opencl.codecache.enable", (String)"False"));
    private final boolean OPENCL_DUMP_BINS = Boolean.parseBoolean(Tornado.getProperty((String)"tornado.opencl.codecache.dump", (String)"False"));
    private final boolean OPENCL_DUMP_SOURCE = Boolean.parseBoolean(Tornado.getProperty((String)"tornado.opencl.source.dump", (String)"False"));
    private final boolean PRINT_LOAD_TIME = false;
    private final String OPENCL_CACHE_DIR = Tornado.getProperty((String)"tornado.opencl.codecache.dir", (String)"/var/opencl-codecache");
    private final String OPENCL_SOURCE_DIR = Tornado.getProperty((String)"tornado.opencl.source.dir", (String)"/var/opencl-compiler");
    private final String OPENCL_LOG_DIR = Tornado.getProperty((String)"tornado.opencl.log.dir", (String)"/var/opencl-logs");
    private static final String DEFAULT_FPGA_CONFIGURATION_FILE_FOR_INTEL = "/etc/intel-fpga.conf";
    private static final String DEFAULT_FPGA_CONFIGURATION_FILE_FOR_INTEL_ONEAPI = "/etc/intel-oneapi-fpga.conf";
    private static final String DEFAULT_FPGA_CONFIGURATION_FILE_FOR_XILINX = "/etc/xilinx-fpga.conf";
    private final String FPGA_CONFIGURATION_FILE = Tornado.getProperty((String)"tornado.fpga.conf.file", null);
    private static final String FPGA_CLEANUP_SCRIPT = System.getenv("TORNADOVM_HOME") + "/bin/cleanFpga.sh";
    private static final String FPGA_AWS_AFI_SCRIPT = System.getenv("TORNADOVM_HOME") + "/bin/aws_post_processing.sh";
    private final StringBuilder OPENCL_BINARIES = TornadoOptions.FPGA_BINARIES;
    private final ConcurrentHashMap<String, OCLInstalledCode> cache;
    private final OCLDeviceContextInterface deviceContext;
    private String fpgaName;
    private String fpgaCompiler;
    private String compilationFlags;
    private String directoryBitstream;
    private boolean isFPGAInAWS;
    private String fpgaSourceDir;
    private ConcurrentHashMap<String, ArrayList<Pair>> pendingTasks;
    private ArrayList<String> linkObjectFiles;
    private boolean kernelAvailable;
    private HashMap<String, String> precompiledBinariesPerDevice;
    private TornadoLogger logger = new TornadoLogger(this.getClass());

    public OCLCodeCache(OCLDeviceContextInterface deviceContext) {
        this.deviceContext = deviceContext;
        this.cache = new ConcurrentHashMap();
        this.pendingTasks = new ConcurrentHashMap();
        this.linkObjectFiles = new ArrayList();
        if (deviceContext.isPlatformFPGA()) {
            this.precompiledBinariesPerDevice = new HashMap();
            this.parseFPGAConfigurationFile();
            if (this.OPENCL_BINARIES != null) {
                this.processPrecompiledBinaries();
            }
        }
    }

    private String trimFirstSpaceFromString(String string) {
        return string.replaceFirst("\\s+", "");
    }

    private boolean tokenStartsAComment(String token) {
        return token.startsWith("#");
    }

    private boolean isQuartusHLSRequired() {
        return this.fpgaCompiler.equals("aoc");
    }

    private void assertIfQuartusHLSIsPresent() {
        if (System.getenv("QUARTUS_ROOT_DIR") == null) {
            throw new TornadoRuntimeException("[ERROR] The FPGA compiler (" + this.fpgaCompiler + ") requires the installation of the Intel(R) Quartus(R) Prime software. You can check if Quartus is installed and whether the QUARTUS_ROOT_DIR variable is properly set.");
        }
    }

    private boolean runOnIntelFPGAWithOneAPI() {
        return System.getenv("ONEAPI_ROOT") != null;
    }

    private String fetchFPGAConfigurationFile() {
        if (this.deviceContext.getDevice().getDeviceVendor().equalsIgnoreCase("xilinx")) {
            return DEFAULT_FPGA_CONFIGURATION_FILE_FOR_XILINX;
        }
        if (this.runOnIntelFPGAWithOneAPI()) {
            return DEFAULT_FPGA_CONFIGURATION_FILE_FOR_INTEL_ONEAPI;
        }
        return DEFAULT_FPGA_CONFIGURATION_FILE_FOR_INTEL;
    }

    private String resolveFPGAConfigurationFileName() {
        if (this.FPGA_CONFIGURATION_FILE != null) {
            return this.FPGA_CONFIGURATION_FILE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.getenv("TORNADOVM_HOME"));
        sb.append(this.fetchFPGAConfigurationFile());
        return sb.toString();
    }

    private void parseFPGAConfigurationFile() {
        try {
            String line;
            FileReader fileReader = new FileReader(this.resolveFPGAConfigurationFileName());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            block16: while ((line = bufferedReader.readLine()) != null) {
                String token;
                StringTokenizer tokenizer = new StringTokenizer(line = this.trimFirstSpaceFromString(line), " =");
                if (!tokenizer.hasMoreElements() || this.tokenStartsAComment(token = tokenizer.nextToken())) continue;
                block8 : switch (token) {
                    case "DEVICE_NAME": {
                        this.fpgaName = tokenizer.nextToken(" =");
                        break;
                    }
                    case "COMPILER": {
                        this.fpgaCompiler = tokenizer.nextToken(" =");
                        break;
                    }
                    case "DIRECTORY_BITSTREAM": {
                        this.fpgaSourceDir = this.directoryBitstream = this.resolveAbsoluteDirectory(tokenizer.nextToken(" ="));
                        break;
                    }
                    case "FLAGS": {
                        StringBuilder buildFlags = new StringBuilder();
                        while (tokenizer.hasMoreElements()) {
                            String flag = tokenizer.nextToken(" =");
                            if (this.tokenStartsAComment(flag)) break block8;
                            if (!flag.contains("-")) continue;
                            if (this.compilationFlags == null) {
                                this.compilationFlags = this.resolveCompilationFlags(tokenizer, buildFlags, flag);
                                continue;
                            }
                            if (buildFlags.toString().isEmpty()) {
                                buildFlags.append(this.compilationFlags);
                            }
                            this.compilationFlags = this.resolveCompilationFlags(tokenizer, buildFlags.append(" "), flag);
                        }
                        continue block16;
                    }
                    case "AWS_ENV": {
                        this.isFPGAInAWS = tokenizer.nextToken(" =").toLowerCase().equals("yes");
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.println("Wrong configuration file or invalid settings. Please ensure that you have configured the configuration file with valid options!");
            System.exit(1);
        }
    }

    private String resolveCompilationFlags(StringTokenizer tokenizer, StringBuilder buildFlags, String flag) {
        String resolvedFlags;
        if (flag.contains("--config")) {
            String fileString = this.resolveAbsoluteDirectory(tokenizer.nextToken(" ="));
            resolvedFlags = buildFlags.append(flag).append(" ").append(fileString).toString();
        } else if (flag.contains("--")) {
            String fileString = tokenizer.nextToken(" =");
            resolvedFlags = buildFlags.append(flag).append(" ").append(fileString).toString();
        } else {
            resolvedFlags = buildFlags.append(flag).toString();
        }
        return resolvedFlags;
    }

    private void processPrecompiledBinaries() {
        String[] binaries = this.OPENCL_BINARIES.toString().split(",");
        if (binaries.length == 1) {
            binaries = this.processPrecompiledBinariesFromFile(binaries[0]);
        } else if (binaries.length % 2 != 0) {
            throw new RuntimeException("tornado.precompiled.binary=<path>,taskName.device");
        }
        for (int i = 0; i < binaries.length; i += 2) {
            String binaryFile = binaries[i];
            String taskAndDeviceInfo = binaries[i + 1];
            String task = taskAndDeviceInfo.split("\\.")[0] + "." + taskAndDeviceInfo.split("\\.")[1];
            String[] driverAndDevice = taskAndDeviceInfo.split("=")[1].split(":");
            int driverIndex = Integer.parseInt(driverAndDevice[0]);
            int deviceIndex = Integer.parseInt(driverAndDevice[1]);
            this.addNewEntryInBitstreamHashMap(task, binaryFile, driverIndex, deviceIndex);
            this.addNewEntryInBitstreamHashMap("oclbackend.lookupBufferAddress", binaryFile, driverIndex, deviceIndex);
        }
    }

    private String[] processPrecompiledBinariesFromFile(String fileName) {
        StringBuilder listBinaries = new StringBuilder();
        BufferedReader fileContent = null;
        try {
            fileContent = new BufferedReader(new FileReader(fileName));
            String line = fileContent.readLine();
            while (line != null) {
                if (!line.isEmpty() && !line.startsWith("#")) {
                    listBinaries.append(line + ",");
                }
                line = fileContent.readLine();
            }
            listBinaries.deleteCharAt(listBinaries.length() - 1);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File: " + fileName + " not found");
        }
        catch (IOException e) {
            throw new TornadoCompilationException(e.getMessage());
        }
        finally {
            try {
                fileContent.close();
            }
            catch (IOException e) {
                throw new TornadoCompilationException(e.getMessage());
            }
        }
        return listBinaries.toString().split(",");
    }

    public boolean isLoadBinaryOptionEnabled() {
        return this.OPENCL_BINARIES != null;
    }

    public String getOpenCLBinary(String taskName) {
        if (this.precompiledBinariesPerDevice != null) {
            return this.precompiledBinariesPerDevice.get(taskName);
        }
        return null;
    }

    private String resolveAbsoluteDirectory(String dir) {
        String tornadoRoot;
        String string = tornadoRoot = this.deviceContext.isPlatformFPGA() ? System.getenv("PWD") : System.getenv("TORNADOVM_HOME");
        if (Paths.get(dir, new String[0]).isAbsolute()) {
            if (!Files.exists(Paths.get(dir, new String[0]), new LinkOption[0])) {
                throw new TornadoRuntimeException("invalid directory: " + dir);
            }
            return dir;
        }
        return tornadoRoot + "/" + dir;
    }

    private void createOrReuseDirectory(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("unable to create dir: %s", new Object[]{dir.toString()});
                this.logger.error(e.getMessage());
            }
        }
        TornadoInternalError.guarantee((boolean)Files.isDirectory(dir, new LinkOption[0]), (String)"target directory is not a directory: %s", (Object[])new Object[]{dir.toAbsolutePath().toString()});
    }

    private Path resolveDirectory(String dir) {
        String tornadoRoot = System.getenv("TORNADOVM_HOME");
        String deviceDir = String.format("device-%d-%d", this.deviceContext.getPlatformContext().getPlatformIndex(), this.deviceContext.getDevice().getIndex());
        Path outDir = Paths.get(tornadoRoot + "/" + dir + "/" + deviceDir, new String[0]);
        this.createOrReuseDirectory(outDir);
        return outDir;
    }

    private Path resolveBitstreamDirectory() {
        Path outDir = Paths.get(this.directoryBitstream, new String[0]);
        this.createOrReuseDirectory(outDir);
        return outDir;
    }

    private Path resolveCacheDirectory() {
        return this.resolveDirectory(this.OPENCL_CACHE_DIR);
    }

    private Path resolveSourceDirectory() {
        return this.resolveDirectory(this.OPENCL_SOURCE_DIR);
    }

    private Path resolveLogDirectory() {
        return this.resolveDirectory(this.OPENCL_LOG_DIR);
    }

    boolean isKernelAvailable() {
        return this.kernelAvailable;
    }

    private void appendSourceToFile(byte[] source, String entryPoint) {
        Path outDir = this.deviceContext.isPlatformFPGA() ? this.resolveBitstreamDirectory() : this.resolveSourceDirectory();
        File file = new File(String.valueOf(outDir) + "/" + entryPoint + OPENCL_SOURCE_SUFFIX);
        RuntimeUtilities.writeStreamToFile((File)file, (byte[])source, (boolean)false);
    }

    private String[] composeIntelHLSCommand(String inputFile, String outputFile) {
        StringJoiner bufferCommand = new StringJoiner(" ");
        bufferCommand.add(this.fpgaCompiler);
        bufferCommand.add(inputFile);
        if (this.compilationFlags != null) {
            bufferCommand.add(this.compilationFlags);
        }
        bufferCommand.add((CharSequence)(TornadoOptions.FPGA_EMULATION ? "-march=emulator" : "-board=" + this.fpgaName));
        bufferCommand.add("-o " + outputFile);
        return bufferCommand.toString().split(" ");
    }

    private String[] composeIntelHLSCommandForOneAPI(String inputFile, String outputFile) {
        StringJoiner bufferCommand = new StringJoiner(" ");
        bufferCommand.add(this.fpgaCompiler);
        bufferCommand.add("--input=" + inputFile);
        bufferCommand.add("--device=" + this.fpgaName + " --cmd=build");
        bufferCommand.add("--ir=" + outputFile + ".aocx");
        return bufferCommand.toString().split(" ");
    }

    private String[] composeXilinxHLSCompileCommand(String inputFile, String kernelName) {
        StringJoiner bufferCommand = new StringJoiner(" ");
        bufferCommand.add(this.fpgaCompiler);
        bufferCommand.add(TornadoOptions.FPGA_EMULATION ? "-t sw_emu" : "-t hw");
        bufferCommand.add("--platform " + this.fpgaName + " -c -k " + kernelName);
        bufferCommand.add("-g -I" + this.directoryBitstream);
        bufferCommand.add("--xp misc:solution_name=" + kernelName);
        bufferCommand.add("--report_dir " + this.directoryBitstream + "reports");
        bufferCommand.add("--log_dir " + this.directoryBitstream + "logs");
        bufferCommand.add("-o " + this.directoryBitstream + kernelName + ".xo " + inputFile);
        return bufferCommand.toString().split(" ");
    }

    private void addObjectKernelsToLinker(StringJoiner bufferCommand) {
        for (String kernelNameObject : this.linkObjectFiles) {
            bufferCommand.add(this.directoryBitstream + kernelNameObject + ".xo");
        }
    }

    private String[] composeXilinxHLSLinkCommand(String entryPoint) {
        StringJoiner bufferCommand = new StringJoiner(" ");
        bufferCommand.add(this.fpgaCompiler);
        bufferCommand.add(TornadoOptions.FPGA_EMULATION ? "-t sw_emu" : "-t hw");
        bufferCommand.add("--platform " + this.fpgaName + " -l -g");
        bufferCommand.add("--xp misc:solution_name=link");
        bufferCommand.add("--report_dir " + this.directoryBitstream + "reports");
        bufferCommand.add("--log_dir " + this.directoryBitstream + "logs");
        if (this.compilationFlags != null) {
            bufferCommand.add(this.compilationFlags);
        }
        bufferCommand.add("--remote_ip_cache " + this.directoryBitstream + "ip_cache");
        bufferCommand.add("-o " + this.directoryBitstream + entryPoint + ".xclbin");
        this.addObjectKernelsToLinker(bufferCommand);
        return bufferCommand.toString().split(" ");
    }

    private void invokeShellCommand(String[] command) {
        try {
            if (command != null) {
                RuntimeUtilities.systemCall((String[])command, (boolean)TornadoOptions.FULL_DEBUG, (String)this.directoryBitstream);
            }
        }
        catch (IOException e) {
            throw new TornadoRuntimeException((Exception)e);
        }
    }

    private boolean shouldGenerateXilinxBitstream(File fpgaBitStreamFile, OCLDeviceContextInterface deviceContext) {
        if (!fpgaBitStreamFile.exists()) {
            return deviceContext.getPlatformContext().getPlatform().getVendor().equals("Xilinx");
        }
        return false;
    }

    private boolean isPlatform(String platformName) {
        return this.deviceContext.getPlatformContext().getPlatform().getVendor().toLowerCase().startsWith(platformName);
    }

    private String[] splitTaskGraphAndTaskName(String id) {
        if (id.contains(".")) {
            String[] names = id.split("\\.");
            return names;
        }
        return new String[]{id};
    }

    private void addNewEntryInBitstreamHashMap(String id, String bitstreamDirectory) {
        String[] driverAndDevice = Tornado.getProperty((String)(id + ".device"), (String)"0:0").split(":");
        this.addNewEntryInBitstreamHashMap(id, bitstreamDirectory, Integer.parseInt(driverAndDevice[0]), Integer.parseInt(driverAndDevice[1]));
    }

    private void addNewEntryInBitstreamHashMap(String id, String bitstreamDirectory, int driverIndex, int deviceIndex) {
        if (this.precompiledBinariesPerDevice != null) {
            String lookupBufferDeviceKernelName = id + String.format(".device=%s:%s", driverIndex, deviceIndex);
            this.precompiledBinariesPerDevice.put(lookupBufferDeviceKernelName, bitstreamDirectory);
        }
    }

    private String getDeviceVendor() {
        return this.deviceContext.getPlatformContext().getPlatform().getVendor().toLowerCase().split("\\(")[0];
    }

    OCLInstalledCode installFPGASource(String id, String entryPoint, byte[] source, boolean printKernel) {
        String[] compilationCommand;
        String inputFile = this.fpgaSourceDir + entryPoint + OPENCL_SOURCE_SUFFIX;
        String outputFile = this.fpgaSourceDir + entryPoint;
        File fpgaBitStreamFile = new File(outputFile);
        this.appendSourceToFile(source, entryPoint);
        if (printKernel) {
            RuntimeUtilities.dumpKernel((byte[])source);
        }
        String[] linkCommand = null;
        String[] taskNames = this.splitTaskGraphAndTaskName(id);
        if (this.pendingTasks.containsKey(taskNames[0])) {
            this.pendingTasks.get(taskNames[0]).add(new Pair(taskNames[1], entryPoint));
        } else {
            ArrayList<Pair> tasks = new ArrayList<Pair>();
            tasks.add(new Pair(taskNames[1], entryPoint));
            this.pendingTasks.put(taskNames[0], tasks);
        }
        if (this.isPlatform("xilinx")) {
            compilationCommand = this.composeXilinxHLSCompileCommand(inputFile, entryPoint);
            this.linkObjectFiles.add(entryPoint);
            linkCommand = this.composeXilinxHLSLinkCommand(entryPoint);
        } else if (this.isPlatform("intel")) {
            if (this.runOnIntelFPGAWithOneAPI()) {
                if (this.isQuartusHLSRequired()) {
                    this.assertIfQuartusHLSIsPresent();
                    compilationCommand = this.composeIntelHLSCommand(inputFile, outputFile);
                } else {
                    compilationCommand = this.composeIntelHLSCommandForOneAPI(inputFile, outputFile);
                }
            } else {
                compilationCommand = this.composeIntelHLSCommand(inputFile, outputFile);
            }
        } else {
            throw new TornadoRuntimeException("[ERROR] FPGA vendor not supported yet.");
        }
        String vendor = this.getDeviceVendor();
        String[] commandRename = new String[]{FPGA_CLEANUP_SCRIPT, vendor, this.fpgaSourceDir, entryPoint};
        Path path = Paths.get(outputFile, new String[0]);
        this.addNewEntryInBitstreamHashMap(id, outputFile);
        if (fpgaBitStreamFile.exists()) {
            return this.installEntryPointForBinaryForFPGAs(id, path, entryPoint);
        }
        this.invokeShellCommand(compilationCommand);
        this.invokeShellCommand(commandRename);
        this.invokeShellCommand(linkCommand);
        if (this.isFPGAInAWS) {
            String[] afiAWSCommand = new String[]{FPGA_AWS_AFI_SCRIPT, this.resolveFPGAConfigurationFileName(), this.directoryBitstream, entryPoint};
            this.invokeShellCommand(afiAWSCommand);
        }
        return this.installEntryPointForBinaryForFPGAs(id, path, entryPoint);
    }

    private boolean isInputSourceSPIRVBinary(byte[] source) {
        int value = (source[0] & 0xFF) + ((source[1] & 0xFF) << 8) + ((source[2] & 0xFF) << 16) + ((source[3] & 0xFF) << 24);
        return value == 119734787;
    }

    private void dumpKernelSource(String id, String entryPoint, String log, byte[] source) {
        FileOutputStream fos;
        Path outDir = this.resolveLogDirectory();
        String identifier = id + "-" + entryPoint;
        this.logger.error("Unable to compile task %s: check logs at %s/%s.log", new Object[]{identifier, outDir.toAbsolutePath(), identifier});
        File file = new File(String.valueOf(outDir) + "/" + identifier + ".log");
        try {
            fos = new FileOutputStream(file);
            try {
                fos.write(log.getBytes());
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            this.logger.error("unable to write error log: ", new Object[]{e.getMessage()});
        }
        file = new File(String.valueOf(outDir) + "/" + identifier + OPENCL_SOURCE_SUFFIX);
        try {
            fos = new FileOutputStream(file);
            try {
                fos.write(source);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            this.logger.error("unable to write error log: ", new Object[]{e.getMessage()});
        }
    }

    private void installCodeInCodeCache(OCLProgram program, String id, String entryPoint, OCLInstalledCode code) {
        this.cache.put(id + "-" + entryPoint, code);
        if ((this.OPENCL_CACHE_ENABLE || this.OPENCL_DUMP_BINS) && !this.deviceContext.getPlatformContext().getPlatform().getVendor().equalsIgnoreCase("Apple")) {
            Path outDir = this.resolveCacheDirectory();
            program.dumpBinaries(String.valueOf(outDir.toAbsolutePath()) + "/" + entryPoint);
        }
    }

    public OCLInstalledCode installSource(TaskDataContext meta, String id, String entryPoint, byte[] source) {
        this.logger.info("Installing code for %s into code cache", new Object[]{entryPoint});
        boolean isSPIRVBinary = this.isInputSourceSPIRVBinary(source);
        OCLProgram program = isSPIRVBinary ? this.deviceContext.createProgramWithIL(source, new long[]{source.length}) : this.deviceContext.createProgramWithSource(source, new long[]{source.length});
        if (this.OPENCL_DUMP_SOURCE) {
            Path outDir = this.resolveSourceDirectory();
            File file = new File(String.valueOf(outDir) + "/" + id + "-" + entryPoint + OPENCL_SOURCE_SUFFIX);
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(source);
            }
            catch (IOException e) {
                this.logger.error("unable to dump source: ", new Object[]{e.getMessage()});
            }
        }
        if (this.deviceContext.getDevice().getDeviceType() == OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR) {
            this.appendSourceToFile(source, entryPoint);
        }
        if (meta.isPrintKernelEnabled()) {
            RuntimeUtilities.dumpKernel((byte[])source);
        }
        this.logger.debug("\tOpenCL compiler flags = %s", new Object[]{meta.getCompilerFlags(TornadoVMBackendType.OPENCL)});
        program.build(meta.getCompilerFlags(TornadoVMBackendType.OPENCL));
        OCLBuildStatus status = program.getStatus(this.deviceContext.getDeviceId());
        this.logger.debug("\tOpenCL compilation status = %s", new Object[]{status.toString()});
        if (status == OCLBuildStatus.CL_BUILD_ERROR) {
            String log = program.getBuildLog(this.deviceContext.getDeviceId());
            System.err.println("\n[ERROR] TornadoVM JIT Compiler - OpenCL Build Error Log:\n\n" + log + "\n");
            this.dumpKernelSource(id, entryPoint, log, source);
            throw new TornadoBailoutRuntimeException("Error during code compilation with the OpenCL driver");
        }
        OCLKernel kernel = null;
        if (status == OCLBuildStatus.CL_BUILD_SUCCESS) {
            kernel = program.clCreateKernel(entryPoint);
            this.kernelAvailable = true;
        }
        OCLInstalledCode code = new OCLInstalledCode(entryPoint, source, (OCLDeviceContext)this.deviceContext, program, kernel, isSPIRVBinary);
        if (status == OCLBuildStatus.CL_BUILD_SUCCESS) {
            this.logger.debug("\tOpenCL Kernel id = 0x%x", new Object[]{kernel.getOclKernelID()});
            this.installCodeInCodeCache(program, id, entryPoint, code);
        } else {
            this.logger.warn("\tunable to compile %s", new Object[]{entryPoint});
            code.invalidate();
        }
        return code;
    }

    private OCLInstalledCode installBinary(String id, String entryPoint, byte[] binary) throws OCLException {
        OCLProgram program;
        this.logger.info("Installing binary for %s into code cache", new Object[]{entryPoint});
        if (entryPoint.contains("-")) {
            entryPoint = entryPoint.split("-")[1];
        }
        boolean isSPIRVBinary = false;
        OCLBuildStatus status = OCLBuildStatus.CL_BUILD_SUCCESS;
        if (this.shouldReuseProgramObject(entryPoint) && this.cache.containsKey(entryPoint)) {
            program = this.cache.get(entryPoint).getProgram();
        } else {
            long afterLoad;
            long beforeLoad = TornadoOptions.TIME_IN_NANOSECONDS ? System.nanoTime() : System.currentTimeMillis();
            isSPIRVBinary = this.isInputSourceSPIRVBinary(binary);
            program = isSPIRVBinary ? this.deviceContext.createProgramWithIL(binary, new long[]{binary.length}) : this.deviceContext.createProgramWithBinary(binary, new long[]{binary.length});
            long l = afterLoad = TornadoOptions.TIME_IN_NANOSECONDS ? System.nanoTime() : System.currentTimeMillis();
            if (program == null) {
                throw new OCLException("unable to load binary for " + entryPoint);
            }
            program.build("");
            status = program.getStatus(this.deviceContext.getDeviceId());
            this.logger.debug("\tOpenCL compilation status = %s", new Object[]{status.toString()});
            String log = program.getBuildLog(this.deviceContext.getDeviceId()).trim();
            if (!log.isEmpty()) {
                this.logger.debug(log);
            }
        }
        OCLKernel kernel = status == OCLBuildStatus.CL_BUILD_SUCCESS ? program.clCreateKernel(entryPoint) : null;
        OCLInstalledCode code = new OCLInstalledCode(entryPoint, binary, (OCLDeviceContext)this.deviceContext, program, kernel, isSPIRVBinary);
        if (status == OCLBuildStatus.CL_BUILD_SUCCESS) {
            this.logger.debug("\tOpenCL Kernel id = 0x%x", new Object[]{kernel.getOclKernelID()});
            this.cache.put(entryPoint, code);
            String taskScheduleName = this.splitTaskGraphAndTaskName(id)[0];
            if (this.pendingTasks.containsKey(taskScheduleName)) {
                ArrayList<Pair> pendingKernels = this.pendingTasks.get(taskScheduleName);
                for (Pair pair : pendingKernels) {
                    String childKernelName = pair.entryPoint;
                    if (childKernelName.equals(entryPoint)) continue;
                    OCLKernel kernel2 = program.clCreateKernel(childKernelName);
                    OCLInstalledCode code2 = new OCLInstalledCode(entryPoint, binary, (OCLDeviceContext)this.deviceContext, program, kernel2, isSPIRVBinary);
                    this.cache.put(taskScheduleName + "." + pair.taskName + "-" + childKernelName, code2);
                }
                pendingKernels.clear();
            }
            if (this.OPENCL_CACHE_ENABLE || this.OPENCL_DUMP_BINS) {
                Path outDir = this.resolveCacheDirectory();
                RuntimeUtilities.writeToFile((String)(outDir.toAbsolutePath().toString() + "/" + entryPoint), (byte[])binary);
            }
        } else {
            this.logger.warn("\tunable to install binary for %s", new Object[]{entryPoint});
            code.invalidate();
        }
        return code;
    }

    private boolean shouldReuseProgramObject(String entryPoint) {
        return this.deviceContext.getDevice().getDeviceName().toLowerCase().startsWith("xilinx");
    }

    public void reset() {
        for (OCLInstalledCode code : this.cache.values()) {
            code.invalidate();
        }
        this.cache.clear();
    }

    public OCLInstalledCode installEntryPointForBinaryForFPGAs(String id, Path lookupPath, String entrypoint) {
        File file = lookupPath.toFile();
        OCLInstalledCode lookupCode = null;
        if (file.length() == 0L) {
            this.logger.error("Empty input binary: %s", new Object[]{file});
        }
        try {
            byte[] binary = Files.readAllBytes(lookupPath);
            lookupCode = this.installBinary(id, entrypoint, binary);
        }
        catch (IOException | OCLException e) {
            this.logger.error("unable to load binary: %s (%s)", new Object[]{file, e.getMessage()});
        }
        return lookupCode;
    }

    public boolean isCached(String key) {
        return this.cache.containsKey(key);
    }

    public OCLInstalledCode getInstalledCode(String id, String entryPoint) {
        return this.cache.get(id + "-" + entryPoint);
    }

    private static class Pair {
        private String taskName;
        private String entryPoint;

        public Pair(String id, String entryPoint) {
            this.taskName = id;
            this.entryPoint = entryPoint;
        }
    }
}

