/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.mm;

import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class PrimitiveSerialiser {
    private static void align(ByteBuffer buffer, int align) {
        while (buffer.position() % align != 0) {
            buffer.put((byte)0);
        }
    }

    public static void put(ByteBuffer buffer, Object value) {
        PrimitiveSerialiser.put(buffer, value, 0);
    }

    public static void put(ByteBuffer buffer, Object value, int alignment) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Character.class, Short.class, HalfFloat.class, Integer.class, Float.class, Long.class, Double.class}, (Object)object, n)) {
            case 0: {
                Byte byteValue = (Byte)object;
                buffer.put(byteValue);
                break;
            }
            case 1: {
                Character charValue = (Character)object;
                buffer.putChar(charValue.charValue());
                break;
            }
            case 2: {
                Short shortValue = (Short)object;
                buffer.putShort(shortValue);
                break;
            }
            case 3: {
                HalfFloat halfFloat = (HalfFloat)object;
                buffer.putShort(halfFloat.getHalfFloatValue());
                break;
            }
            case 4: {
                Integer intValue = (Integer)object;
                buffer.putInt(intValue);
                break;
            }
            case 5: {
                Float floatValue = (Float)object;
                buffer.putFloat(floatValue.floatValue());
                break;
            }
            case 6: {
                Long longValue = (Long)object;
                buffer.putLong(longValue);
                break;
            }
            case 7: {
                Double doubleValue = (Double)object;
                buffer.putDouble(doubleValue);
                break;
            }
            default: {
                new TornadoLogger().warn("unable to serialise: %s (%s)", new Object[]{value, value.getClass().getName()});
            }
        }
        if (alignment != 0) {
            PrimitiveSerialiser.align(buffer, alignment);
        }
    }
}

