/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.logging;

import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class Logger {
    public static void traceCodeGen(BACKEND backend, String message, Object ... args) {
        if (TornadoOptions.TRACE_CODE_GEN) {
            System.out.printf("\u001b[36m[" + backend.backendName() + "-CodeGen] " + message + "\u001b[0m\n", args);
        }
    }

    public static void traceBuildLIR(BACKEND backend, String message, Object ... args) {
        if (TornadoOptions.TRACE_BUILD_LIR) {
            System.out.printf("\u001b[32m[" + backend.backendName() + "-BuildLIR] " + message + "\u001b[0m\n", args);
        }
    }

    public static void traceRuntime(BACKEND backend, String message, Object ... args) {
        System.out.printf("\u001b[33m[" + backend.backendName() + "-Runtime] " + message + "\u001b[0m\n", args);
    }

    public static enum BACKEND {
        OpenCL("OpenCL"),
        PTX("PTX"),
        SPIRV("SPIRV");

        String backendName;

        private BACKEND(String name) {
            this.backendName = name;
        }

        public String backendName() {
            return this.backendName;
        }
    }
}

