/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkLocalArray;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;

public class TornadoLocalMemoryAllocation
extends BasePhase<TornadoHighTierContext> {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoHighTierContext context) {
        if (!context.hasMeta()) {
            return;
        }
        if (context.getMeta().getDomain() != null && context.getMeta().getDomain().getDepth() != 0) {
            NodeIterable sumNodes = graph.getNodes();
            for (Node n : sumNodes) {
                ConstantNode newLengthNode;
                if (!(n instanceof MarkLocalArray) || (newLengthNode = ConstantNode.forInt((int)this.calculateLocalMemAllocSize(context), (StructuredGraph)graph)) == n.inputs().first()) continue;
                n.inputs().first().replaceAndDelete((Node)newLengthNode);
            }
        }
    }

    private int calculateLocalMemAllocSize(TornadoHighTierContext context) {
        int value;
        int maxBlockSize = (int)context.getDeviceMapping().getPhysicalDevice().getDeviceMaxWorkItemSizes()[0];
        if (context.getDeviceMapping().getPhysicalDevice().getDeviceMaxWorkItemSizes()[0] == (long)context.getMeta().getDomain().get(0).cardinality()) {
            maxBlockSize /= 4;
        }
        if ((value = Math.min(Math.max(maxBlockSize, context.getMeta().getOpenCLGpuBlock2DX()), context.getMeta().getDomain().get(0).cardinality())) == 0) {
            return 0;
        }
        while (context.getMeta().getDomain().get(0).cardinality() % value != 0) {
            --value;
        }
        return value;
    }
}

