/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.memalloc;

import java.util.ArrayDeque;
import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.AccessIndexedNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.graal.nodes.calc.TornadoAddressArithmeticNode;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;

public class TornadoFieldAccessFixup
extends BasePhase<TornadoHighTierContext> {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoHighTierContext context) {
        ArrayDeque worklist = new ArrayDeque();
        graph.getNodes().filter(ParameterNode.class).forEach(parameterNode -> {
            worklist.addAll(parameterNode.usages().filter(LoadFieldNode.class).snapshot());
            parameterNode.usages().filter(usage -> usage instanceof PiNode && ((PiNode)usage).object() instanceof ParameterNode).forEach(usage -> worklist.addAll(usage.usages().filter(LoadFieldNode.class).snapshot()));
        });
        while (!worklist.isEmpty()) {
            LoadFieldNode loadField = (LoadFieldNode)worklist.poll();
            worklist.addAll(loadField.usages().filter(LoadFieldNode.class).snapshot());
            loadField.usages().forEach(usage -> {
                if (usage instanceof AccessIndexedNode) {
                    AccessIndexedNode accessIndexedNode = (AccessIndexedNode)usage;
                    ValueNode base = loadField.object();
                    if (base instanceof PiNode) {
                        base = ((PiNode)base).object();
                    } else if (base instanceof TornadoAddressArithmeticNode) {
                        base = ((TornadoAddressArithmeticNode)base).getBase();
                    }
                    TornadoAddressArithmeticNode addNode = new TornadoAddressArithmeticNode(base, (ValueNode)loadField);
                    graph.addWithoutUnique((Node)addNode);
                    accessIndexedNode.setArray((ValueNode)addNode);
                } else if (usage instanceof AccessFieldNode) {
                    AccessFieldNode accessFieldNode = (AccessFieldNode)usage;
                    ValueNode base = loadField.object();
                    if (base instanceof PiNode) {
                        base = ((PiNode)base).object();
                    } else if (base instanceof TornadoAddressArithmeticNode) {
                        base = ((TornadoAddressArithmeticNode)base).getBase();
                    }
                    TornadoAddressArithmeticNode addNode = new TornadoAddressArithmeticNode(base, (ValueNode)loadField);
                    graph.addWithoutUnique((Node)addNode);
                    if (accessFieldNode instanceof LoadFieldNode) {
                        ((LoadFieldNode)accessFieldNode).setObject((ValueNode)addNode);
                    } else if (accessFieldNode instanceof StoreFieldNode) {
                        StoreFieldNode storeFieldNodeUsage = (StoreFieldNode)accessFieldNode;
                        StoreFieldNode storeFieldNode = new StoreFieldNode((ValueNode)addNode, storeFieldNodeUsage.field(), storeFieldNodeUsage.value());
                        graph.addWithoutUnique((Node)storeFieldNode);
                        graph.replaceFixedWithFixed((FixedWithNextNode)storeFieldNodeUsage, (FixedWithNextNode)storeFieldNode);
                    } else {
                        TornadoInternalError.shouldNotReachHere((String)"Unexpected node type = %s", (Object[])new Object[]{accessFieldNode.getClass().getName()});
                    }
                } else if (usage instanceof OffsetAddressNode && (usage.usages().filter(JavaWriteNode.class).isNotEmpty() || usage.usages().filter(JavaReadNode.class).isNotEmpty())) {
                    ValueNode base = loadField.object();
                    if (base instanceof PiNode) {
                        PiNode basePI = (PiNode)base;
                        base = basePI.object();
                    } else if (base instanceof TornadoAddressArithmeticNode) {
                        TornadoAddressArithmeticNode tornadoAddressArithmeticNode = (TornadoAddressArithmeticNode)base;
                        base = tornadoAddressArithmeticNode.getBase();
                    }
                    TornadoAddressArithmeticNode addNode = new TornadoAddressArithmeticNode(base, (ValueNode)loadField);
                    graph.addWithoutUnique((Node)addNode);
                    usage.replaceFirstInput((Node)loadField, (Node)addNode);
                }
            });
        }
    }
}

