/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.loops;

import java.util.Optional;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopFragmentInside;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoMidTierContext;

public class TornadoPartialLoopUnrollPhase
extends BasePhase<MidTierContext> {
    private static final int LOOP_UNROLL_FACTOR_DEFAULT = 2;
    private static final int LOOP_BOUND_UPPER_LIMIT = 16384;
    private static final int GRAPH_NODES_UPPER_LIMIT = 40000;

    private static OptimizationStatus partialUnroll(StructuredGraph graph, MidTierContext context) {
        TornadoLoopsData dataCounted;
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        canonicalizer.apply(graph, (Object)context);
        try {
            dataCounted = new TornadoLoopsData(graph);
        }
        catch (NullPointerException nullPointerException) {
            return OptimizationStatus.ERROR;
        }
        dataCounted.detectCountedLoops();
        try {
            dataCounted.countedLoops().forEach(loop -> {
                int loopBound;
                if (LoopTransformations.isUnrollableLoop((LoopEx)loop) && TornadoPartialLoopUnrollPhase.isPowerOfTwo(loopBound = loop.counted().getLimit().asJavaConstant().asInt()) && loopBound < 16384) {
                    LoopFragmentInside loopBody = loop.inside().duplicate();
                    loopBody.insertWithinAfter(loop, null);
                }
            });
            new DeadCodeEliminationPhase().apply(graph);
        }
        catch (NullPointerException runtimeException) {
            return OptimizationStatus.ERROR;
        }
        return OptimizationStatus.SUCCESS;
    }

    private static int getUnrollFactor() {
        return TornadoPartialLoopUnrollPhase.isPowerOfTwo(TornadoOptions.UNROLL_FACTOR) && TornadoOptions.UNROLL_FACTOR <= 32 ? TornadoOptions.UNROLL_FACTOR : 2;
    }

    private static int getUpperGraphLimit(int initialGraphNodeCount) {
        return initialGraphNodeCount + 40000;
    }

    private static boolean isPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private StructuredGraph checkStatus(StructuredGraph graph, StructuredGraph snapshot, OptimizationStatus status) {
        return status != OptimizationStatus.SUCCESS ? snapshot : graph;
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        TornadoMidTierContext tornadoMidTierContext = (TornadoMidTierContext)context;
        if (!tornadoMidTierContext.getMeta().applyPartialLoopUnroll()) {
            return;
        }
        if (!graph.hasLoops()) {
            return;
        }
        int initialNodeCount = graph.getNodeCount();
        int unrollFactor = TornadoPartialLoopUnrollPhase.getUnrollFactor();
        StructuredGraph snapshot = (StructuredGraph)graph.copy(TornadoCoreRuntime.getDebugContext());
        int i = 0;
        while (Math.pow(2.0, i) < (double)unrollFactor) {
            if (graph.getNodeCount() < TornadoPartialLoopUnrollPhase.getUpperGraphLimit(initialNodeCount)) {
                OptimizationStatus status = TornadoPartialLoopUnrollPhase.partialUnroll(graph, context);
                graph = this.checkStatus(graph, snapshot, status);
                if (status != OptimizationStatus.SUCCESS) {
                    return;
                }
            }
            ++i;
        }
    }

    private static enum OptimizationStatus {
        SUCCESS,
        ERROR;

    }
}

