/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.loops;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;

public class TornadoLoopUnroller
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;

    public TornadoLoopUnroller(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    private static boolean shouldFullUnroll(OptionValues options, LoopEx loop) {
        if (!loop.isCounted() || !loop.counted().isConstantMaxTripCount()) {
            return false;
        }
        CountedLoopInfo counted = loop.counted();
        long maxTrips = counted.constantMaxTripCount().asLong();
        int maxNodes = counted.isExactTripCount() && counted.isConstantExactTripCount() ? (Integer)DefaultLoopPolicies.Options.ExactFullUnrollMaxNodes.getValue(options) : (Integer)DefaultLoopPolicies.Options.FullUnrollMaxNodes.getValue(options);
        maxNodes = Math.min(maxNodes, (Integer)GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount());
        int size = Math.max(1, loop.size() - 1 - loop.loopBegin().phis().count());
        if ((long)size * maxTrips <= (long)maxNodes) {
            int loops = 0;
            int ifs = 0;
            for (Node node : loop.inside().nodes()) {
                if (node instanceof ControlFlowAnchorNode) {
                    return false;
                }
                if (node instanceof LoopBeginNode) {
                    ++loops;
                    continue;
                }
                if (!(node instanceof IfNode)) continue;
                ++ifs;
            }
            return loops - ifs == 0;
        }
        return false;
    }

    public void execute(StructuredGraph graph, CoreProviders providers) {
        this.run(graph, providers);
    }

    protected void run(StructuredGraph graph, CoreProviders providers) {
        if (graph.hasLoops()) {
            boolean peeled;
            do {
                peeled = false;
                TornadoLoopsData dataCounted = new TornadoLoopsData(graph);
                dataCounted.detectCountedLoops();
                for (LoopEx loop : dataCounted.countedLoops()) {
                    if (!TornadoLoopUnroller.shouldFullUnroll(graph.getOptions(), loop)) continue;
                    TornadoCoreRuntime.getDebugContext().log("FullUnroll %s", (Object)loop);
                    LoopTransformations.fullUnroll((LoopEx)loop, (CoreProviders)providers, (CanonicalizerPhase)this.canonicalizer);
                    TornadoCoreRuntime.getDebugContext().dump(2, (Object)graph, "After fullUnroll %s", (Object)loop);
                    peeled = true;
                    break;
                }
                dataCounted.deleteUnusedNodes();
            } while (peeled);
        }
    }
}

