/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.loops;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.drivers.common.compiler.phases.loops.LoopCanonicalizer;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;

public class TornadoLoopCanonicalization
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        if (graph.hasLoops()) {
            TornadoLoopsData data = new TornadoLoopsData(graph);
            List loops = data.outerFirst();
            Collections.reverse(loops);
            for (LoopEx loop : loops) {
                int numBackedges = loop.loopBegin().loopEnds().count();
                if (numBackedges <= 1) continue;
                LoopBeginNode loopBegin = loop.loopBegin();
                LoopCanonicalizer.canonicalizeLoop(graph, loopBegin);
            }
        }
    }
}

