/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.loops;

import java.util.Iterator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class LoopCanonicalizer {
    public static void canonicalizeLoop(StructuredGraph graph, LoopBeginNode loopBegin) {
        int numBackedges = loopBegin.loopEnds().count();
        LoopEndNode[] oldLoopEndNodes = new LoopEndNode[numBackedges];
        EndNode[] replacementEndNodes = new EndNode[numBackedges];
        PhiNode[] oldPhiNodes = new PhiNode[loopBegin.phis().count()];
        PhiNode[] newPhiNodes = new PhiNode[loopBegin.phis().count()];
        int index = 0;
        Iterator iterator = loopBegin.phis().iterator();
        while (iterator.hasNext()) {
            PhiNode phi;
            oldPhiNodes[index] = phi = (PhiNode)iterator.next();
            ++index;
        }
        index = 0;
        iterator = loopBegin.loopEnds().iterator();
        while (iterator.hasNext()) {
            LoopEndNode oldLoopEnd;
            oldLoopEndNodes[index] = oldLoopEnd = (LoopEndNode)iterator.next();
            ++index;
        }
        MergeNode mergeNode = (MergeNode)graph.addWithoutUnique((Node)new MergeNode());
        LoopEndNode newLoopEnd = (LoopEndNode)graph.addWithoutUnique((Node)new LoopEndNode(loopBegin));
        mergeNode.setNext((FixedNode)newLoopEnd);
        for (index = 0; index < numBackedges; ++index) {
            replacementEndNodes[index] = (EndNode)graph.addWithoutUnique((Node)new EndNode());
            mergeNode.addForwardEnd(replacementEndNodes[index]);
        }
        index = 0;
        for (PhiNode oldPhi : oldPhiNodes) {
            PhiNode newPhi = (PhiNode)oldPhi.copyWithInputs(true);
            newPhi.clearInputs();
            newPhi.setMerge((AbstractMergeNode)mergeNode);
            for (int i = 0; i < numBackedges; ++i) {
                newPhi.initializeValueAt(i, oldPhi.valueAt((AbstractEndNode)oldLoopEndNodes[i]));
            }
            newPhiNodes[index] = newPhi;
            ++index;
        }
        for (index = 0; index < numBackedges; ++index) {
            loopBegin.removeEnd((AbstractEndNode)oldLoopEndNodes[index]);
            oldLoopEndNodes[index].replaceAndDelete((Node)replacementEndNodes[index]);
        }
        index = 0;
        for (PhiNode oldPhi : oldPhiNodes) {
            oldPhi.initializeValueAt(1, (ValueNode)newPhiNodes[index]);
            ++index;
        }
    }
}

