/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.guards;

import java.util.Optional;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoMidTierContext;

public class ExceptionCheckingElimination
extends BasePhase<TornadoMidTierContext> {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoMidTierContext context) {
        graph.getNodes().filter(GuardedNode.class::isInstance).snapshot().forEach(node -> {
            GuardedNode guardedNode = (GuardedNode)node;
            GuardingNode patt0$temp = guardedNode.getGuard();
            if (patt0$temp instanceof GuardNode) {
                GuardNode guard = (GuardNode)patt0$temp;
                LogicNode condition = guard.getCondition();
                if (condition instanceof IsNullNode) {
                    Node input = condition.inputs().first();
                    if (guard.isNegated()) {
                        condition.replaceFirstInput(input, (Node)LogicConstantNode.contradiction((Graph)graph));
                    } else {
                        condition.replaceFirstInput(input, (Node)LogicConstantNode.tautology((Graph)graph));
                    }
                } else if (condition instanceof IntegerBelowNode) {
                    ValueNode x = ((IntegerBelowNode)condition).getX();
                    condition.replaceFirstInput((Node)x, graph.addOrUnique((Node)ConstantNode.forInt((int)Integer.MAX_VALUE)));
                }
            }
        });
    }
}

