/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.guards;

import java.util.Optional;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.AccessIndexedNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;

public class BoundCheckEliminationPhase
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        NodeIterable guardNodes = graph.getNodes().filter(GuardNode.class);
        if (guardNodes.count() == 0) {
            return;
        }
        for (GuardNode guardNode : guardNodes) {
            DeoptimizationReason deoptReason = guardNode.getReason();
            if (deoptReason != DeoptimizationReason.BoundsCheckException || guardNode.getAnchor() instanceof AccessIndexedNode) continue;
            guardNode.safeDelete();
        }
    }
}

