/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.analysis;

import java.util.HashMap;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoCodeGenerator;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;

public class TornadoValueTypeReplacement
extends BasePhase<TornadoHighTierContext> {
    private static final NodePredicate valueTypeFilter = new NodePredicate(){

        public boolean apply(Node node) {
            return ((NewInstanceNode)node).instanceClass().getAnnotation(Vector.class) != null;
        }
    };

    private void simplify(NewInstanceNode newInstance) {
        TornadoCodeGenerator.debug((String)"simplify: node=%s", (Object[])new Object[]{newInstance.toString()});
        HashMap fieldToValue = new HashMap();
        newInstance.usages().filter(StoreFieldNode.class).forEach(store -> {
            fieldToValue.put(store.field(), store.value());
            store.clearInputs();
            store.graph().removeFixed((FixedWithNextNode)store);
        });
        if (fieldToValue.isEmpty()) {
            return;
        }
        for (ResolvedJavaField field : fieldToValue.keySet()) {
            TornadoCodeGenerator.debug((String)"simplify: field=%s -> value=%s", (Object[])new Object[]{field.getName(), ((ValueNode)fieldToValue.get(field)).toString()});
        }
        newInstance.graph().getNodes().filter(LoadFieldNode.class).forEach(load -> {
            if (load.object() == newInstance) {
                TornadoCodeGenerator.debug((String)"simplify: load field=%s", (Object[])new Object[]{load.field().getName()});
                TornadoCodeGenerator.debug((String)"simplify: load field=%s -> value=%s", (Object[])new Object[]{load.field().getName(), ((ValueNode)fieldToValue.get(load.field())).toString()});
                load.replaceAtUsages((Node)fieldToValue.get(load.field()));
                load.graph().removeFixed((FixedWithNextNode)load);
            }
        });
    }

    public void execute(StructuredGraph graph, TornadoHighTierContext context) {
        this.run(graph, context);
    }

    protected void run(StructuredGraph graph, TornadoHighTierContext context) {
        graph.getNodes().filter(NewInstanceNode.class).filter(valueTypeFilter).forEach(this::simplify);
        graph.maybeCompress();
    }
}

