/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.compiler.phases.analysis;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopFragmentInside;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.domain.Domain;
import uk.ac.manchester.tornado.runtime.domain.DomainTree;
import uk.ac.manchester.tornado.runtime.domain.IntDomain;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelRangeNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;

public class TornadoShapeAnalysis
extends BasePhase<TornadoHighTierContext> {
    private TornadoLogger logger = new TornadoLogger(((Object)((Object)this)).getClass());

    private static int getIntegerValue(ValueNode value) {
        if (value instanceof ConstantNode) {
            return value.asJavaConstant().asInt();
        }
        return Integer.MIN_VALUE;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private int getMaxLevelNestedLoops(StructuredGraph graph) {
        int dimensions = 1;
        if (graph.hasLoops()) {
            TornadoLoopsData data = new TornadoLoopsData(graph);
            data.detectCountedLoops();
            List loops = data.outerFirst();
            for (LoopEx loopEx : loops) {
                LoopFragmentInside inside = loopEx.inside();
                NodeBitMap nodes = inside.nodes();
                List snapshot = nodes.filter(LoopBeginNode.class).snapshot();
                if (snapshot.size() <= 1) continue;
                dimensions = Math.max(dimensions, snapshot.size());
            }
        }
        return dimensions;
    }

    private void setDomainTree(int dimensions, List<ParallelRangeNode> ranges, TornadoHighTierContext context) {
        DomainTree domainTree = new DomainTree(dimensions);
        int lastIndex = -1;
        boolean valid = true;
        for (int i = 0; i < dimensions; ++i) {
            ParallelRangeNode range = ranges.get(i);
            int index = range.index();
            if (index == lastIndex || TornadoShapeAnalysis.getIntegerValue(range.offset().value()) == Integer.MIN_VALUE || TornadoShapeAnalysis.getIntegerValue(range.stride().value()) == Integer.MIN_VALUE || TornadoShapeAnalysis.getIntegerValue(range.value()) == Integer.MIN_VALUE) {
                valid = false;
                this.logger.info("unsupported multiple parallel loops");
                break;
            }
            domainTree.set(index, (Domain)new IntDomain(TornadoShapeAnalysis.getIntegerValue(range.offset().value()), TornadoShapeAnalysis.getIntegerValue(range.stride().value()), TornadoShapeAnalysis.getIntegerValue(range.value())));
            lastIndex = index;
        }
        if (valid) {
            this.logger.trace("loop nest depth = %d\n", new Object[]{domainTree.getDepth()});
            this.logger.debug("discovered parallel domain: %s\n", new Object[]{domainTree});
            context.getMeta().setDomain(domainTree);
        }
    }

    private boolean shouldPerformShapeAnalysis(TornadoHighTierContext context) {
        return context.hasMeta() && context.getMeta().getDomain() == null;
    }

    protected void run(StructuredGraph graph, TornadoHighTierContext context) {
        if (!this.shouldPerformShapeAnalysis(context)) {
            return;
        }
        int dimensions = this.getMaxLevelNestedLoops(graph);
        List ranges = graph.getNodes().filter(ParallelRangeNode.class).snapshot();
        if (ranges.size() < dimensions) {
            dimensions = ranges.size();
        }
        Collections.sort(ranges);
        this.setDomainTree(dimensions, ranges, context);
    }
}

