/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common.code;

import java.lang.foreign.ValueLayout;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.HalfFloat;

public class CodeUtil {
    public static CallingConvention getCallingConvention(CodeCacheProvider codeCache, CallingConvention.Type type, ResolvedJavaMethod method) {
        JavaType[] argTypes;
        Signature sig = method.getSignature();
        JavaType retType = sig.getReturnType(method.getDeclaringClass());
        int sigCount = sig.getParameterCount(false);
        int argIndex = 0;
        if (!method.isStatic()) {
            argTypes = new JavaType[sigCount + 1];
            argTypes[argIndex++] = method.getDeclaringClass();
        } else {
            argTypes = new JavaType[sigCount];
        }
        ResolvedJavaType declaringClass = method.getDeclaringClass();
        for (int i = 0; i < sigCount; ++i) {
            argTypes[argIndex++] = sig.getParameterType(i, declaringClass);
        }
        Local[] locals = method.getLocalVariableTable().getLocalsAt(0);
        return CodeUtil.getCallingConvention(type, retType, argTypes, codeCache.getTarget(), locals);
    }

    private static CallingConvention getCallingConvention(CallingConvention.Type type, JavaType returnType, JavaType[] argTypes, TargetDescription target, Local[] locals) {
        int variableIndex = 0;
        Variable[] inputParameters = new Variable[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            if (CodeUtil.isHalfFloat(argTypes[i])) {
                inputParameters[i] = new Variable((ValueKind)LIRKind.value((PlatformKind)target.arch.getPlatformKind(JavaKind.Short)), variableIndex);
            } else {
                JavaKind javaKind = CodeUtil.convertJavaKind(argTypes[i]);
                inputParameters[i] = new Variable((ValueKind)LIRKind.value((PlatformKind)target.arch.getPlatformKind(javaKind)), variableIndex);
            }
            ++i;
            ++variableIndex;
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : returnType.getJavaKind();
        LIRKind lirKind = LIRKind.value((PlatformKind)target.arch.getPlatformKind(returnKind));
        Variable returnParameter = new Variable((ValueKind)lirKind, variableIndex);
        return new CallingConvention(0, (AllocatableValue)returnParameter, (AllocatableValue[])inputParameters);
    }

    public static boolean isHalfFloat(JavaType type) {
        return type.toJavaName().equals(HalfFloat.class.getName());
    }

    public static JavaKind convertJavaKind(JavaType type) {
        return switch (type.getName()) {
            case "Ljava/lang/Boolean;" -> JavaKind.Boolean;
            case "Ljava/lang/Byte;" -> JavaKind.Byte;
            case "Ljava/lang/Short;" -> JavaKind.Short;
            case "Ljava/lang/Character;" -> JavaKind.Char;
            case "Ljava/lang/Integer;" -> JavaKind.Int;
            case "Ljava/lang/Long;" -> JavaKind.Long;
            case "Ljava/lang/Float;" -> JavaKind.Float;
            case "Ljava/lang/Double;" -> JavaKind.Double;
            default -> type.getJavaKind();
        };
    }

    public static JavaKind javaKindFromBitSize(int bitSize, boolean isFloat) {
        if (isFloat) {
            return switch (bitSize) {
                case 32 -> JavaKind.Float;
                case 64 -> JavaKind.Double;
                default -> throw new IllegalArgumentException("Unsupported floating point bit size: " + bitSize);
            };
        }
        return switch (bitSize) {
            case 8 -> JavaKind.Byte;
            case 16 -> JavaKind.Short;
            case 32 -> JavaKind.Int;
            case 64 -> JavaKind.Long;
            default -> throw new IllegalArgumentException("Unsupported integer bit size: " + bitSize);
        };
    }

    public static JavaKind getJavaKindFromValueLayoutClass(Class valueLayout) {
        if (valueLayout == ValueLayout.OfInt.class) {
            return JavaKind.Int;
        }
        if (valueLayout == ValueLayout.OfDouble.class) {
            return JavaKind.Double;
        }
        if (valueLayout == ValueLayout.OfFloat.class) {
            return JavaKind.Float;
        }
        if (valueLayout == ValueLayout.OfLong.class) {
            return JavaKind.Long;
        }
        if (valueLayout == ValueLayout.OfBoolean.class) {
            return JavaKind.Boolean;
        }
        if (valueLayout == ValueLayout.OfByte.class) {
            return JavaKind.Byte;
        }
        if (valueLayout == ValueLayout.OfChar.class) {
            return JavaKind.Char;
        }
        if (valueLayout == ValueLayout.OfShort.class) {
            return JavaKind.Short;
        }
        throw new TornadoRuntimeException("Class type " + String.valueOf(valueLayout) + " not supported.");
    }

    public static Class getValueLayoutClass(ValueNode valueLayoutFieldNode) {
        if (!(valueLayoutFieldNode instanceof LoadFieldNode)) {
            throw new TornadoRuntimeException("Expected a LoadFieldNode but got " + valueLayoutFieldNode.getClass().getSimpleName());
        }
        LoadFieldNode loadFieldNode = (LoadFieldNode)valueLayoutFieldNode;
        ResolvedJavaField fieldNode = loadFieldNode.field();
        String className = fieldNode.getType().toJavaName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new TornadoRuntimeException("Class type " + className + " not found.");
        }
    }
}

