/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.common;

import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.api.TornadoTargetDevice;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoOutOfMemoryException;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public abstract class TornadoBufferProvider {
    protected final TornadoDeviceContext deviceContext;
    protected final HashMap<Access, ArrayList<BufferContainer>> freeBuffers;
    protected final HashMap<Access, ArrayList<BufferContainer>> usedBuffers;
    protected long currentMemoryAvailable;
    private TornadoLogger logger = new TornadoLogger(this.getClass());
    private static final String RESET = "\u001b[0m";
    public static final String YELLOW = "\u001b[33m";
    private static final String OUT_OF_MEMORY_MESSAGE = "\u001b[33m\n\tTo increase the maximum device memory, use -Dtornado.device.memory=<X>GB\n\u001b[0m";

    protected TornadoBufferProvider(TornadoDeviceContext deviceContext) {
        this.deviceContext = deviceContext;
        this.usedBuffers = this.initializeBufferHashMap();
        this.freeBuffers = this.initializeBufferHashMap();
        this.currentMemoryAvailable = TornadoOptions.DEVICE_AVAILABLE_MEMORY;
    }

    private HashMap<Access, ArrayList<BufferContainer>> initializeBufferHashMap() {
        HashMap<Access, ArrayList<BufferContainer>> bufferAccesses = new HashMap<Access, ArrayList<BufferContainer>>();
        for (Access access : Access.values()) {
            ArrayList bufferList = new ArrayList();
            bufferAccesses.put(access, bufferList);
        }
        return bufferAccesses;
    }

    public boolean reuseBufferForBatchProcessing(long batchSize, Access access, int numberOfBuffersForAccessType) {
        boolean matchFound = false;
        if (!this.usedBuffers.get(access).isEmpty()) {
            for (BufferContainer bufferContainer : this.usedBuffers.get(access)) {
                if (this.usedBuffers.get(access).size() < numberOfBuffersForAccessType) {
                    return false;
                }
                long size = bufferContainer.size;
                matchFound = size == batchSize + TornadoNativeArray.ARRAY_HEADER;
                if (!matchFound) continue;
                this.logger.debug("Reuse buffer %s from the used-list for batch processing. Batch Size = %s, Access = %s %n", new Object[]{bufferContainer, batchSize, access});
            }
        }
        return matchFound;
    }

    protected abstract long allocateBuffer(long var1, Access var3);

    protected abstract void releaseBuffer(long var1);

    private synchronized long allocate(long size, Access access) {
        long buffer = this.allocateBuffer(size, access);
        this.currentMemoryAvailable -= size;
        BufferContainer bufferInfo = new BufferContainer(buffer, size, access);
        this.usedBuffers.get(access).add(bufferInfo);
        this.logger.debug("Buffer %s has been allocated and included in the usedBuffers list with access: %s", new Object[]{bufferInfo, access});
        return bufferInfo.buffer;
    }

    private synchronized void freeBuffers(long size, Access access) {
        long remainingSize = size;
        while (!this.freeBuffers.get(access).isEmpty() && remainingSize > 0L) {
            BufferContainer bufferInfo = this.freeBuffers.get(access).removeFirst();
            TornadoInternalError.guarantee((!this.usedBuffers.get(access).contains(bufferInfo) ? 1 : 0) != 0, (String)"This buffer should not be used", (Object[])new Object[0]);
            remainingSize -= bufferInfo.size;
            this.currentMemoryAvailable += bufferInfo.size;
            this.releaseBuffer(bufferInfo.buffer);
        }
    }

    public synchronized long deallocate(Access access) {
        long spaceDeallocated = 0L;
        while (!this.freeBuffers.get(access).isEmpty()) {
            BufferContainer bufferInfo = this.freeBuffers.get(access).removeFirst();
            TornadoInternalError.guarantee((!this.usedBuffers.get(access).contains(bufferInfo) ? 1 : 0) != 0, (String)"This buffer should not be used", (Object[])new Object[0]);
            this.currentMemoryAvailable += bufferInfo.size;
            spaceDeallocated += bufferInfo.size;
            this.releaseBuffer(bufferInfo.buffer);
        }
        return spaceDeallocated;
    }

    private synchronized BufferContainer markBufferUsed(int freeBufferIndex, Access access) {
        BufferContainer buffer = this.freeBuffers.get(access).get(freeBufferIndex);
        this.usedBuffers.get(access).add(buffer);
        this.freeBuffers.get(access).remove(buffer);
        return buffer;
    }

    private synchronized int bufferIndexOfAFreeSpace(long sizeInBytes, Access access) {
        int minBufferIndex = -1;
        for (int i = 0; i < this.freeBuffers.get(access).size(); ++i) {
            BufferContainer bufferInfo = this.freeBuffers.get(access).get(i);
            if (bufferInfo.size < sizeInBytes || minBufferIndex != -1 && bufferInfo.size >= this.freeBuffers.get((Object)access).get((int)minBufferIndex).size) continue;
            minBufferIndex = i;
        }
        return minBufferIndex;
    }

    private synchronized long freeUnusedNativeBufferAndAssignRegion(long sizeInBytes, Access access) {
        this.freeBuffers(sizeInBytes, access);
        if (sizeInBytes <= this.currentMemoryAvailable) {
            return this.allocate(sizeInBytes, access);
        }
        throw new TornadoOutOfMemoryException("Unable to allocate " + sizeInBytes + " bytes of memory.\u001b[33m\n\tTo increase the maximum device memory, use -Dtornado.device.memory=<X>GB\n\u001b[0m");
    }

    public synchronized long getOrAllocateBufferWithSize(long sizeInBytes, Access access) {
        TornadoTargetDevice device = this.deviceContext.getDevice();
        if (sizeInBytes <= this.currentMemoryAvailable && sizeInBytes < device.getDeviceMaxAllocationSize()) {
            return this.allocate(sizeInBytes, access);
        }
        if (sizeInBytes < device.getDeviceMaxAllocationSize()) {
            int minBufferIndex = this.bufferIndexOfAFreeSpace(sizeInBytes, access);
            if (minBufferIndex != -1) {
                return this.markBufferUsed((int)minBufferIndex, (Access)access).buffer;
            }
            return this.freeUnusedNativeBufferAndAssignRegion(sizeInBytes, access);
        }
        throw new TornadoOutOfMemoryException("[ERROR] Unable to allocate " + sizeInBytes + " bytes of memory.\u001b[33m\n\tTo increase the maximum device memory, use -Dtornado.device.memory=<X>GB\n\u001b[0m");
    }

    public synchronized void markBufferReleased(long buffer, Access access) {
        int foundIndex = -1;
        for (int i = 0; i < this.usedBuffers.get(access).size(); ++i) {
            if (this.usedBuffers.get(access).get(i) == null || this.usedBuffers.get((Object)access).get((int)i).buffer != buffer) continue;
            foundIndex = i;
            break;
        }
        if (foundIndex != -1) {
            BufferContainer removedBuffer = this.usedBuffers.get(access).remove(foundIndex);
            this.freeBuffers.get(access).add(removedBuffer);
            this.logger.debug("Buffer %s has been released and included in the freeBuffers list for access: %s", new Object[]{removedBuffer, access});
        }
    }

    public boolean isNumFreeBuffersAvailable(int numBuffers, Access access) {
        return this.freeBuffers.get(access).size() >= numBuffers;
    }

    public synchronized void resetBuffers(Access access) {
        this.freeBuffers(TornadoOptions.DEVICE_AVAILABLE_MEMORY, access);
    }

    private record BufferContainer(long buffer, long size, Access access) {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BufferContainer)) {
                return false;
            }
            BufferContainer that = (BufferContainer)object;
            return this.buffer == that.buffer && this.size == that.size;
        }

        @Override
        public int hashCode() {
            return (int)this.buffer;
        }
    }
}

