/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers;

import java.util.Arrays;
import java.util.HashMap;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class TornadoDeviceQuery {
    private static HashMap<TornadoVMBackendType, String> colourMapping = new HashMap();

    private static String formatSize(long v) {
        if (v < 1024L) {
            return v + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        return String.format("%.1f %sB", (double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static void main(String[] args) {
        String verboseFlag = "";
        if (args.length != 0) {
            verboseFlag = args[0];
        }
        StringBuilder deviceInfoBuffer = new StringBuilder().append("\n");
        int numDrivers = TornadoRuntimeProvider.getTornadoRuntime().getNumBackends();
        deviceInfoBuffer.append("Number of Tornado drivers: " + numDrivers + "\n");
        for (int driverIndex = 0; driverIndex < numDrivers; ++driverIndex) {
            TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex);
            TornadoVMBackendType backendType = TornadoRuntimeProvider.getTornadoRuntime().getBackendType(driverIndex);
            String colour = colourMapping.get(backendType);
            int numDevices = driver.getNumDevices();
            deviceInfoBuffer.append("Driver: " + colour + driver.getName() + "\u001b[0m\n");
            deviceInfoBuffer.append("  Total number of " + driver.getName() + " devices  : " + numDevices + "\n");
            for (int deviceIndex = 0; deviceIndex < numDevices; ++deviceIndex) {
                deviceInfoBuffer.append("  Tornado device=" + driverIndex + ":" + deviceIndex);
                if (driverIndex == 0 && deviceIndex == 0) {
                    deviceInfoBuffer.append("  (DEFAULT)");
                }
                deviceInfoBuffer.append("\n");
                deviceInfoBuffer.append("\t" + colour + backendType.toString() + "\u001b[0m -- " + String.valueOf(driver.getDevice(deviceIndex))).append("\n");
                if (verboseFlag.equals("verbose")) {
                    deviceInfoBuffer.append("\t\tGlobal Memory Size: " + TornadoDeviceQuery.formatSize(driver.getDevice(deviceIndex).getMaxGlobalMemory()) + "\n");
                    deviceInfoBuffer.append("\t\tLocal Memory Size: " + TornadoDeviceQuery.formatSize(driver.getDevice(deviceIndex).getDeviceLocalMemorySize()) + "\n");
                    deviceInfoBuffer.append("\t\tWorkgroup Dimensions: " + driver.getDevice(deviceIndex).getDeviceMaxWorkgroupDimensions().length + "\n");
                    if (!TornadoOptions.VIRTUAL_DEVICE_ENABLED) {
                        deviceInfoBuffer.append("\t\tTotal Number of Block Threads: " + Arrays.toString(driver.getDevice(deviceIndex).getPhysicalDevice().getDeviceMaxWorkGroupSize()) + "\n");
                    }
                    deviceInfoBuffer.append("\t\tMax WorkGroup Configuration: " + Arrays.toString(driver.getDevice(deviceIndex).getDeviceMaxWorkgroupDimensions()) + "\n");
                    deviceInfoBuffer.append("\t\tDevice OpenCL C version: " + driver.getDevice(deviceIndex).getDeviceOpenCLCVersion() + "\n");
                }
                deviceInfoBuffer.append("\n");
            }
        }
        System.out.println(deviceInfoBuffer.toString());
    }

    static {
        colourMapping.put(TornadoVMBackendType.OPENCL, "\u001b[36m");
        colourMapping.put(TornadoVMBackendType.PTX, "\u001b[32m");
        colourMapping.put(TornadoVMBackendType.SPIRV, "\u001b[35m");
    }
}

