/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.stencil;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.stencil.Stencil;

public class StencilTornado
extends BenchmarkDriver {
    private final int sz;
    private final int n;
    private final float FAC = 0.0f;
    private FloatArray a0;
    private FloatArray a1;
    private FloatArray ainit;

    public StencilTornado(int iterations, int dataSize) {
        super(iterations);
        this.sz = (int)Math.cbrt(dataSize / 8) / 2;
        this.n = this.sz - 2;
    }

    @Override
    public void setUp() {
        this.a0 = new FloatArray(this.sz * this.sz * this.sz);
        this.a1 = new FloatArray(this.sz * this.sz * this.sz);
        this.ainit = new FloatArray(this.sz * this.sz * this.sz);
        this.a1.init(0.0f);
        Random rand = new Random(7L);
        for (int i = 1; i < this.n + 1; ++i) {
            for (int j = 1; j < this.n + 1; ++j) {
                for (int k = 1; k < this.n + 1; ++k) {
                    this.ainit.set(i * this.sz * this.sz + j * this.sz + k, rand.nextFloat());
                }
            }
        }
        Stencil.copy(this.sz, this.ainit, this.a0);
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a0, this.a1}).task("stencil", Stencil::stencil3d, (Object)this.n, (Object)this.sz, (Object)this.a0, (Object)this.a1, (Object)Float.valueOf(0.0f)).task("copy", Stencil::copy, (Object)this.sz, (Object)this.a1, (Object)this.a0).transferToHost(1, new Object[]{this.a0});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a0 = null;
        this.a1 = null;
        this.ainit = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray b0 = new FloatArray(this.ainit.getSize());
        FloatArray b1 = new FloatArray(this.ainit.getSize());
        Stencil.copy(this.sz, this.ainit, b0);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        int i = 0;
        while ((long)i < this.iterations) {
            Stencil.stencil3d(this.n, this.sz, b0, b1, 0.0f);
            Stencil.copy(this.sz, b1, b0);
            ++i;
        }
        float ulp = TornadoMath.findULPDistance((FloatArray)this.a0, (FloatArray)b0);
        return ulp < MAX_ULP;
    }

    @Override
    protected void barrier() {
        this.executionResult.transferToHost(new Object[]{this.a0});
    }
}

