/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.stencil;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.stencil.Stencil;

public class StencilJava
extends BenchmarkDriver {
    private final int sz;
    private final int n;
    private final float FAC = 0.0f;
    private FloatArray a0;
    private FloatArray a1;

    public StencilJava(int iterations, int dataSize) {
        super(iterations);
        this.sz = (int)Math.cbrt(dataSize / 8) / 2;
        this.n = this.sz - 2;
    }

    @Override
    public void setUp() {
        this.a0 = new FloatArray(this.sz * this.sz * this.sz);
        this.a1 = new FloatArray(this.sz * this.sz * this.sz);
        this.a0.init(0.0f);
        this.a1.init(0.0f);
        Random rand = new Random(7L);
        for (int i = 1; i < this.n + 1; ++i) {
            for (int j = 1; j < this.n + 1; ++j) {
                for (int k = 1; k < this.n + 1; ++k) {
                    this.a0.set(i * this.sz * this.sz + j * this.sz + k, rand.nextFloat());
                }
            }
        }
    }

    @Override
    public void tearDown() {
        this.a0 = null;
        this.a1 = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        Stencil.stencil3d(this.n, this.sz, this.a0, this.a1, 0.0f);
        Stencil.copy(this.sz, this.a0, this.a1);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

