/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.stencil;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.stencil.Stencil;

public class JMHStencil {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void stencilJava(BenchmarkSetup state) {
        Stencil.stencil3d(state.n, state.sz, state.a0, state.a1, state.FAC);
        Stencil.copy(state.sz, state.a0, state.a1);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void stencilTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHStencil.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private final int size = Integer.parseInt(System.getProperty("x", "1048576"));
        int sz;
        int n;
        private final float FAC = 0.0f;
        private FloatArray a0;
        private FloatArray a1;
        private FloatArray ainit;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.sz = (int)Math.cbrt(this.size / 8) / 2;
            this.n = this.sz - 2;
            this.a0 = new FloatArray(this.sz * this.sz * this.sz);
            this.a1 = new FloatArray(this.sz * this.sz * this.sz);
            this.ainit = new FloatArray(this.sz * this.sz * this.sz);
            this.a1.init(0.0f);
            Random rand = new Random(7L);
            for (int i = 1; i < this.n + 1; ++i) {
                for (int j = 1; j < this.n + 1; ++j) {
                    for (int k = 1; k < this.n + 1; ++k) {
                        this.ainit.set(i * this.sz * this.sz + j * this.sz + k, rand.nextFloat());
                    }
                }
            }
            Stencil.copy(this.sz, this.ainit, this.a0);
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a0, this.a1}).task("stencil", Stencil::stencil3d, (Object)this.n, (Object)this.sz, (Object)this.a0, (Object)this.a1, (Object)Float.valueOf(0.0f)).task("copy", Stencil::copy, (Object)this.sz, (Object)this.a1, (Object)this.a0).transferToHost(1, new Object[]{this.a0});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

