/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.spmv;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;
import uk.ac.manchester.tornado.benchmarks.spmv.Benchmark;
import uk.ac.manchester.tornado.matrix.SparseMatrixUtils;

public class SpmvTornado
extends BenchmarkDriver {
    private final SparseMatrixUtils.CSRMatrix<FloatArray> matrix;
    private FloatArray v;
    private FloatArray y;

    public SpmvTornado(int iterations, SparseMatrixUtils.CSRMatrix<FloatArray> matrix) {
        super(iterations);
        this.matrix = matrix;
    }

    @Override
    public void setUp() {
        this.v = new FloatArray(this.matrix.size);
        this.y = new FloatArray(this.matrix.size);
        Benchmark.initData(this.v);
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.matrix.vals, this.matrix.cols, this.matrix.rows, this.v, this.y}).task("spmv", LinearAlgebraArrays::spmv, (Object)((FloatArray)this.matrix.vals), (Object)this.matrix.cols, (Object)this.matrix.rows, (Object)this.v, (Object)this.matrix.size, (Object)this.y).transferToHost(1, new Object[]{this.y});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.v = null;
        this.y = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray ref = new FloatArray(this.matrix.size);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        LinearAlgebraArrays.spmv((FloatArray)this.matrix.vals, this.matrix.cols, this.matrix.rows, this.v, this.matrix.size, ref);
        float ulp = TornadoMath.findULPDistance((FloatArray)this.y, (FloatArray)ref);
        System.out.printf("ulp is %f\n", Float.valueOf(ulp));
        return ulp < MAX_ULP;
    }
}

