/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.spmv;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;
import uk.ac.manchester.tornado.benchmarks.spmv.Benchmark;
import uk.ac.manchester.tornado.matrix.SparseMatrixUtils;

public class SpmvJava
extends BenchmarkDriver {
    private final SparseMatrixUtils.CSRMatrix<FloatArray> matrix;
    private FloatArray v;
    private FloatArray y;

    public SpmvJava(int iterations, SparseMatrixUtils.CSRMatrix<FloatArray> matrix) {
        super(iterations);
        this.matrix = matrix;
    }

    @Override
    public void setUp() {
        this.v = new FloatArray(this.matrix.size);
        this.y = new FloatArray(this.matrix.size);
        Benchmark.initData(this.v);
    }

    @Override
    public void tearDown() {
        this.v = null;
        this.y = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        LinearAlgebraArrays.spmv((FloatArray)this.matrix.vals, this.matrix.cols, this.matrix.rows, this.v, this.matrix.size, this.y);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

