/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.spmv;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;
import uk.ac.manchester.tornado.benchmarks.spmv.Benchmark;
import uk.ac.manchester.tornado.matrix.SparseMatrixUtils;

public class JMHSpmv {
    @org.openjdk.jmh.annotations.Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void spmvJava(BenchmarkSetup state) {
        SparseMatrixUtils.CSRMatrix<FloatArray> matrix = state.matrix;
        LinearAlgebraArrays.spmv((FloatArray)matrix.vals, matrix.cols, matrix.rows, state.v, matrix.size, state.y);
    }

    @org.openjdk.jmh.annotations.Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void spmvTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSpmv.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private SparseMatrixUtils.CSRMatrix<FloatArray> matrix;
        private FloatArray v;
        private FloatArray y;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            String path = System.getProperty("spmv.matrix", "/bcsstk32.mtx");
            this.matrix = SparseMatrixUtils.loadMatrixF((InputStream)Benchmark.class.getResourceAsStream(path));
            this.v = new FloatArray(this.matrix.size);
            this.y = new FloatArray(this.matrix.size);
            Benchmark.initData(this.v);
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.matrix.vals, this.matrix.cols, this.matrix.rows, this.v, this.y}).task("spmv", LinearAlgebraArrays::spmv, (Object)((FloatArray)this.matrix.vals), (Object)this.matrix.cols, (Object)this.matrix.rows, (Object)this.v, (Object)this.matrix.size, (Object)this.y).transferToHost(1, new Object[]{this.y});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

