/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.spmv;

import java.io.InputStream;
import java.util.Random;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.spmv.SpmvJava;
import uk.ac.manchester.tornado.benchmarks.spmv.SpmvTornado;
import uk.ac.manchester.tornado.matrix.SparseMatrixUtils;

public class Benchmark
extends BenchmarkRunner {
    private SparseMatrixUtils.CSRMatrix<FloatArray> matrix;
    private String path;

    public static void initData(FloatArray v) {
        Random rand = new Random();
        rand.setSeed(7L);
        for (int i = 0; i < v.getSize(); ++i) {
            v.set(i, rand.nextFloat() * 100.0f);
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            String fullPath = args[1];
            this.path = fullPath.substring(fullPath.lastIndexOf("/") + 1);
            this.matrix = SparseMatrixUtils.loadMatrixF((String)fullPath);
        } else {
            this.path = System.getProperty("spmv.matrix", "/bcsstk32.mtx");
            this.matrix = SparseMatrixUtils.loadMatrixF((InputStream)Benchmark.class.getResourceAsStream(this.path));
            this.iterations = Integer.parseInt(System.getProperty("spmv.iterations", "1400"));
        }
    }

    @Override
    protected String getName() {
        return "spmv";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d-%s", this.getName(), this.iterations, this.matrix.size, this.path);
    }

    @Override
    protected String getConfigString() {
        return String.format("matrix=%s", this.path);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new SpmvJava(this.iterations, this.matrix);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new SpmvTornado(this.iterations, this.matrix);
    }
}

