/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.sgemv;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class SgemvTornado
extends BenchmarkDriver {
    private final int m;
    private final int n;
    private FloatArray a;
    private FloatArray x;
    private FloatArray y;

    public SgemvTornado(int iterations, int m, int n) {
        super(iterations);
        this.m = m;
        this.n = n;
    }

    @Override
    public void setUp() {
        int i;
        this.a = new FloatArray(this.m * this.n);
        this.x = new FloatArray(this.n);
        this.y = new FloatArray(this.n);
        Random random = new Random();
        for (i = 0; i < this.m; ++i) {
            this.a.set(i * (this.m + 1), 1.0f);
        }
        for (i = 0; i < this.n; ++i) {
            this.x.set(i, random.nextFloat());
        }
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a, this.x}).task("sgemv", LinearAlgebraArrays::sgemv, (Object)this.m, (Object)this.n, (Object)this.a, (Object)this.x, (Object)this.y).transferToHost(1, new Object[]{this.y});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a = null;
        this.x = null;
        this.y = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray result = new FloatArray(this.n);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        LinearAlgebraArrays.sgemv(this.m, this.n, this.a, this.x, result);
        float ulp = TornadoMath.findULPDistance((FloatArray)this.y, (FloatArray)result);
        return ulp < MAX_ULP;
    }
}

