/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.sgemv;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class SgemvJava
extends BenchmarkDriver {
    private final int m;
    private final int n;
    private FloatArray a;
    private FloatArray x;
    private FloatArray y;

    public SgemvJava(int iterations, int m, int n) {
        super(iterations);
        this.m = m;
        this.n = n;
    }

    @Override
    public void setUp() {
        int i;
        this.a = new FloatArray(this.m * this.n);
        this.x = new FloatArray(this.n);
        this.y = new FloatArray(this.n);
        Random random = new Random();
        for (i = 0; i < this.m; ++i) {
            this.a.set(i * (this.m + 1), 1.0f);
        }
        for (i = 0; i < this.n; ++i) {
            this.x.set(i, random.nextFloat());
        }
    }

    @Override
    public void tearDown() {
        this.a = null;
        this.x = null;
        this.y = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        LinearAlgebraArrays.sgemv(this.m, this.n, this.a, this.x, this.y);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

