/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.sgemv;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class JMHSgemV {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void sgemVJava(BenchmarkSetup state) {
        LinearAlgebraArrays.sgemv(state.m, state.n, state.a, state.x, state.y);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void sgemVTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSgemV.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private final int m = Integer.parseInt(System.getProperty("x", "8192"));
        private final int n = Integer.parseInt(System.getProperty("y", "8192"));
        private FloatArray a;
        private FloatArray x;
        private FloatArray y;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            int i;
            this.a = new FloatArray(this.m * this.n);
            this.x = new FloatArray(this.n);
            this.y = new FloatArray(this.n);
            Random random = new Random();
            for (i = 0; i < this.m; ++i) {
                this.a.set(i * (this.m + 1), 1.0f);
            }
            for (i = 0; i < this.n; ++i) {
                this.x.set(i, random.nextFloat());
            }
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a, this.x}).task("sgemv", LinearAlgebraArrays::sgemv, (Object)this.m, (Object)this.n, (Object)this.a, (Object)this.x, (Object)this.y).transferToHost(1, new Object[]{this.y});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

