/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.sgemm;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.sgemm.SgemmJava;
import uk.ac.manchester.tornado.benchmarks.sgemm.SgemmTornado;

public class Benchmark
extends BenchmarkRunner {
    private int width;
    private int height;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 3) {
            this.iterations = Integer.parseInt(args[0]);
            this.width = Integer.parseInt(args[1]);
            this.height = Integer.parseInt(args[2]);
        } else {
            this.iterations = 20;
            this.width = 512;
            this.height = 512;
        }
    }

    @Override
    protected String getName() {
        return "sgemm";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d-%d", this.getName(), this.iterations, this.width, this.height);
    }

    @Override
    protected String getConfigString() {
        return String.format("width=%d, height=%d", this.width, this.height);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new SgemmJava(this.iterations, this.width, this.height);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new SgemmTornado(this.iterations, this.width, this.height);
    }
}

