/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.saxpy;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class SaxpyTornado
extends BenchmarkDriver {
    private final int numElements;
    private FloatArray x;
    private FloatArray y;
    private final float alpha = 2.0f;

    public SaxpyTornado(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.x = new FloatArray(this.numElements);
        this.y = new FloatArray(this.numElements);
        for (int i = 0; i < this.numElements; ++i) {
            this.x.set(i, (float)i);
        }
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.x});
        this.taskGraph.task("saxpy", LinearAlgebraArrays::saxpy, (Object)Float.valueOf(2.0f), (Object)this.x, (Object)this.y);
        this.taskGraph.transferToHost(1, new Object[]{this.y});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.x = null;
        this.y = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray result = new FloatArray(this.numElements);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        LinearAlgebraArrays.saxpy(2.0f, this.x, result);
        float ulp = TornadoMath.findULPDistance((FloatArray)this.y, (FloatArray)result);
        return ulp < MAX_ULP;
    }
}

