/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.saxpy;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class SaxpyJava
extends BenchmarkDriver {
    private final int numElements;
    private FloatArray x;
    private FloatArray y;
    private final float alpha = 2.0f;

    public SaxpyJava(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.x = new FloatArray(this.numElements);
        this.y = new FloatArray(this.numElements);
        for (int i = 0; i < this.numElements; ++i) {
            this.x.set(i, (float)i);
        }
    }

    @Override
    public void tearDown() {
        this.x = null;
        this.y = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        LinearAlgebraArrays.saxpy(2.0f, this.x, this.y);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

