/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.saxpy;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class JMHSaxpy {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void saxpyJava(BenchmarkSetup state) {
        LinearAlgebraArrays.saxpy(state.alpha, state.x, state.y);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void saxpyTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSaxpy.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private int numElements = Integer.parseInt(System.getProperty("x", "16777216"));
        private FloatArray x;
        private FloatArray y;
        private final float alpha = 2.0f;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.x = new FloatArray(this.numElements);
            this.y = new FloatArray(this.numElements);
            for (int i = 0; i < this.numElements; ++i) {
                this.x.set(i, (float)i);
            }
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.x}).task("saxpy", LinearAlgebraArrays::saxpy, (Object)Float.valueOf(2.0f), (Object)this.x, (Object)this.y).transferToHost(1, new Object[]{this.y});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

