/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.rotatevector;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class RotateTornado
extends BenchmarkDriver {
    private final int numElements;
    private VectorFloat3 input;
    private VectorFloat3 output;
    private Matrix4x4Float m;

    public RotateTornado(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.input = new VectorFloat3(this.numElements);
        this.output = new VectorFloat3(this.numElements);
        this.m = new Matrix4x4Float();
        this.m.identity();
        Float3 value = new Float3(1.0f, 2.0f, 3.0f);
        for (int i = 0; i < this.numElements; ++i) {
            this.input.set(i, value);
        }
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.input});
        this.taskGraph.task("rotateVector", GraphicsKernels::rotateVector, (Object)this.output, (Object)this.m, (Object)this.input);
        this.taskGraph.transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.input = null;
        this.output = null;
        this.m = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        VectorFloat3 result = new VectorFloat3(this.numElements);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        GraphicsKernels.rotateVector(result, this.m, this.input);
        float maxULP = 0.0f;
        for (int i = 0; i < this.numElements; ++i) {
            float ulp = FloatOps.findMaxULP((Float3)this.output.get(i), (Float3)result.get(i));
            if (!(ulp > maxULP)) continue;
            maxULP = ulp;
        }
        return Float.compare(maxULP, MAX_ULP) <= 0;
    }
}

