/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.rotatevector;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class RotateJava
extends BenchmarkDriver {
    private final int numElements;
    private VectorFloat3 input;
    private VectorFloat3 output;
    private Matrix4x4Float m;

    public RotateJava(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.input = new VectorFloat3(this.numElements);
        this.output = new VectorFloat3(this.numElements);
        this.m = new Matrix4x4Float();
        this.m.identity();
        Float3 value = new Float3(1.0f, 2.0f, 3.0f);
        for (int i = 0; i < this.numElements; ++i) {
            this.input.set(i, value);
        }
    }

    @Override
    public void tearDown() {
        this.input = null;
        this.output = null;
        this.m = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.rotateVector(this.output, this.m, this.input);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

