/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.rotateimage;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class RotateStreams
extends BenchmarkDriver {
    private final int numElementsX;
    private final int numElementsY;
    private ImageFloat3 input;
    private ImageFloat3 output;
    private Matrix4x4Float m;

    public RotateStreams(int iterations, int numElementsX, int numElementsY) {
        super(iterations);
        this.numElementsX = numElementsX;
        this.numElementsY = numElementsY;
    }

    @Override
    public void setUp() {
        this.input = new ImageFloat3(this.numElementsX, this.numElementsY);
        this.output = new ImageFloat3(this.numElementsX, this.numElementsY);
        this.m = new Matrix4x4Float();
        this.m.identity();
        Float3 value = new Float3(1.0f, 2.0f, 3.0f);
        for (int i = 0; i < this.input.Y(); ++i) {
            for (int j = 0; j < this.input.X(); ++j) {
                this.input.set(j, i, value);
            }
        }
    }

    @Override
    public void tearDown() {
        this.input = null;
        this.output = null;
        this.m = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.rotateImageStreams(this.output, this.m, this.input);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

