/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.renderTrack;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class RenderTrackTornado
extends BenchmarkDriver {
    private int size;
    private ImageFloat3 input;
    private ImageByte3 output;

    public RenderTrackTornado(int size, int iterations) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.output = new ImageByte3(this.size, this.size);
        this.input = new ImageFloat3(this.size, this.size);
        Random r = new Random();
        for (int i = 0; i < this.input.X(); ++i) {
            for (int j = 0; j < this.input.Y(); ++j) {
                float value = (float)r.nextInt(10) * -1.0f;
                this.input.set(i, j, new Float3((float)i, (float)j, value));
            }
        }
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.input}).task("renderTrack", ComputeKernels::renderTrack, (Object)this.output, (Object)this.input).transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.input = null;
        this.output = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    private static boolean validate(ImageFloat3 input, ImageByte3 outputTornado) {
        ImageByte3 validationOutput = new ImageByte3(outputTornado.X(), outputTornado.Y());
        ComputeKernels.renderTrack(validationOutput, input);
        for (int i = 0; i < validationOutput.Y(); ++i) {
            for (int j = 0; j < validationOutput.X(); ++j) {
                if (validationOutput.get(i, j).getX() == outputTornado.get(i, j).getX() && validationOutput.get(i, j).getY() == outputTornado.get(i, j).getY() && validationOutput.get(i, j).getZ() == outputTornado.get(i, j).getZ()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validate(TornadoDevice device) {
        ImageByte3 outputTornado = new ImageByte3(this.size, this.size);
        ImageFloat3 inputValidation = new ImageFloat3(this.size, this.size);
        Random r = new Random();
        for (int i = 0; i < inputValidation.X(); ++i) {
            for (int j = 0; j < inputValidation.Y(); ++j) {
                float value = (float)r.nextInt(10) * -1.0f;
                inputValidation.set(i, j, new Float3((float)i, (float)j, value));
            }
        }
        TaskGraph s0 = new TaskGraph("s0").task("t0", ComputeKernels::renderTrack, (Object)outputTornado, (Object)inputValidation).transferToHost(1, new Object[]{outputTornado});
        ImmutableTaskGraph immutableTaskGraph = s0.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withDevice(device).execute();
        return RenderTrackTornado.validate(inputValidation, outputTornado);
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

