/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.renderTrack;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class RenderTrackJava
extends BenchmarkDriver {
    private int size;
    private ImageFloat3 input;
    private ImageByte3 output;

    public RenderTrackJava(int size, int iterations) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.output = new ImageByte3(this.size, this.size);
        this.input = new ImageFloat3(this.size, this.size);
        Random r = new Random();
        for (int i = 0; i < this.input.X(); ++i) {
            for (int j = 0; j < this.input.Y(); ++j) {
                float value = (float)r.nextInt(10) * -1.0f;
                this.input.set(i, j, new Float3((float)i, (float)j, value));
            }
        }
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.renderTrack(this.output, this.input);
    }
}

