/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.renderTrack;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.renderTrack.RenderTrackJava;
import uk.ac.manchester.tornado.benchmarks.renderTrack.RenderTrackTornado;

public class Benchmark
extends BenchmarkRunner {
    private int size;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            this.size = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            System.out.println("[ERROR] Two arguments are needed: <iterations> <size>");
        } else {
            this.iterations = 51;
            this.size = 8192;
        }
    }

    @Override
    protected String getName() {
        return "renderTrack";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d", this.getName(), this.iterations, this.size);
    }

    @Override
    protected String getConfigString() {
        return String.format("size=%d", this.size);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new RenderTrackJava(this.size, this.iterations);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new RenderTrackTornado(this.size, this.iterations);
    }
}

