/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.nbody;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class NBodyTornado
extends BenchmarkDriver {
    private float delT;
    private float espSqr;
    private FloatArray posSeq;
    private FloatArray velSeq;
    private int numBodies;

    public NBodyTornado(int numBodies, int iterations) {
        super(iterations);
        this.numBodies = numBodies;
    }

    @Override
    public void setUp() {
        int i;
        this.delT = 0.005f;
        this.espSqr = 500.0f;
        FloatArray auxPositionRandom = new FloatArray(this.numBodies * 4);
        FloatArray auxVelocityZero = new FloatArray(this.numBodies * 3);
        for (i = 0; i < auxPositionRandom.getSize(); ++i) {
            auxPositionRandom.set(i, (float)Math.random());
        }
        auxVelocityZero.init(0.0f);
        this.posSeq = new FloatArray(this.numBodies * 4);
        this.velSeq = new FloatArray(this.numBodies * 4);
        if (auxPositionRandom.getSize() >= 0) {
            for (i = 0; i < auxPositionRandom.getSize(); ++i) {
                this.posSeq.set(i, auxPositionRandom.get(i));
            }
        }
        if (auxVelocityZero.getSize() >= 0) {
            for (i = 0; i < auxVelocityZero.getSize(); ++i) {
                this.velSeq.set(i, auxVelocityZero.get(i));
            }
        }
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.velSeq, this.posSeq}).task("t0", ComputeKernels::nBody, (Object)this.numBodies, (Object)this.posSeq, (Object)this.velSeq, (Object)Float.valueOf(this.delT), (Object)Float.valueOf(this.espSqr));
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.posSeq = null;
        this.velSeq = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        int i;
        boolean val = true;
        this.delT = 0.005f;
        this.espSqr = 500.0f;
        FloatArray auxPositionRandom = new FloatArray(this.numBodies * 4);
        FloatArray auxVelocityZero = new FloatArray(this.numBodies * 3);
        for (i = 0; i < auxPositionRandom.getSize(); ++i) {
            auxPositionRandom.set(i, (float)Math.random());
        }
        auxVelocityZero.init(0.0f);
        this.posSeq = new FloatArray(this.numBodies * 4);
        this.velSeq = new FloatArray(this.numBodies * 4);
        FloatArray posSeqSeq = new FloatArray(this.numBodies * 4);
        FloatArray velSeqSeq = new FloatArray(this.numBodies * 4);
        for (i = 0; i < auxPositionRandom.getSize(); ++i) {
            this.posSeq.set(i, auxPositionRandom.get(i));
            posSeqSeq.set(i, auxPositionRandom.get(i));
        }
        for (i = 0; i < auxVelocityZero.getSize(); ++i) {
            this.velSeq.set(i, auxVelocityZero.get(i));
            velSeqSeq.set(i, auxVelocityZero.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("benchmark");
        taskGraph.task("t0", ComputeKernels::nBody, (Object)this.numBodies, (Object)this.posSeq, (Object)this.velSeq, (Object)Float.valueOf(this.delT), (Object)Float.valueOf(this.espSqr));
        taskGraph.transferToHost(2, new Object[]{this.posSeq, this.velSeq});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withPreCompilation();
        TornadoExecutionResult executionResult = executionPlan.withPreCompilation().withDevice(device).execute();
        executionResult.transferToHost(new Object[]{this.posSeq, this.velSeq});
        executionPlan.clearProfiles();
        ComputeKernels.nBody(this.numBodies, posSeqSeq, velSeqSeq, this.delT, this.espSqr);
        for (int i2 = 0; i2 < this.numBodies * 4; ++i2) {
            if ((double)TornadoMath.abs((float)(posSeqSeq.get(i2) - this.posSeq.get(i2))) > 0.01) {
                val = false;
                break;
            }
            if (!((double)TornadoMath.abs((float)(this.velSeq.get(i2) - velSeqSeq.get(i2))) > 0.01)) continue;
            val = false;
            break;
        }
        System.out.printf("Number validation: " + val + "\n", new Object[0]);
        return val;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

