/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.nbody;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class NBodyJava
extends BenchmarkDriver {
    private float delT;
    private float espSqr;
    private FloatArray posSeq;
    private FloatArray velSeq;
    private int numBodies;

    public NBodyJava(int numBodies, int iterations) {
        super(iterations);
        this.numBodies = numBodies;
    }

    @Override
    public void setUp() {
        int i;
        this.delT = 0.005f;
        this.espSqr = 500.0f;
        FloatArray auxPositionRandom = new FloatArray(this.numBodies * 4);
        FloatArray auxVelocityZero = new FloatArray(this.numBodies * 3);
        for (i = 0; i < auxPositionRandom.getSize(); ++i) {
            auxPositionRandom.set(i, (float)Math.random());
        }
        auxVelocityZero.init(0.0f);
        this.posSeq = new FloatArray(this.numBodies * 4);
        this.velSeq = new FloatArray(this.numBodies * 4);
        if (auxPositionRandom.getSize() >= 0) {
            for (i = 0; i < auxPositionRandom.getSize(); ++i) {
                this.posSeq.set(i, auxPositionRandom.get(i));
            }
        }
        if (auxVelocityZero.getSize() >= 0) {
            for (i = 0; i < auxVelocityZero.getSize(); ++i) {
                this.velSeq.set(i, auxVelocityZero.get(i));
            }
        }
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.nBody(this.numBodies, this.posSeq, this.velSeq, this.delT, this.espSqr);
    }
}

