/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.nbody;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHNBody {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void nbodyJava(BenchmarkSetup state) {
        ComputeKernels.nBody(state.numBodies, state.posSeq, state.velSeq, state.delT, state.espSqr);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void nbodyTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHNBody.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        int numBodies = Integer.parseInt(System.getProperty("x", "16384"));
        float delT;
        float espSqr;
        FloatArray velSeq;
        private FloatArray posSeq;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            int i;
            this.delT = 0.005f;
            this.espSqr = 500.0f;
            FloatArray auxPositionRandom = new FloatArray(this.numBodies * 4);
            FloatArray auxVelocityZero = new FloatArray(this.numBodies * 3);
            for (i = 0; i < auxPositionRandom.getSize(); ++i) {
                auxPositionRandom.set(i, (float)Math.random());
            }
            auxVelocityZero.init(0.0f);
            this.posSeq = new FloatArray(this.numBodies * 4);
            this.velSeq = new FloatArray(this.numBodies * 4);
            if (auxPositionRandom.getSize() >= 0) {
                for (i = 0; i < auxPositionRandom.getSize(); ++i) {
                    this.posSeq.set(i, auxPositionRandom.get(i));
                }
            }
            if (auxVelocityZero.getSize() >= 0) {
                for (i = 0; i < auxVelocityZero.getSize(); ++i) {
                    this.velSeq.set(i, auxVelocityZero.get(i));
                }
            }
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.velSeq, this.posSeq}).task("t0", ComputeKernels::nBody, (Object)this.numBodies, (Object)this.posSeq, (Object)this.velSeq, (Object)Float.valueOf(this.delT), (Object)Float.valueOf(this.espSqr)).transferToHost(1, new Object[]{this.posSeq, this.velSeq});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

