/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.nbody;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.nbody.NBodyJava;
import uk.ac.manchester.tornado.benchmarks.nbody.NBodyTornado;

public class Benchmark
extends BenchmarkRunner {
    private int numBodies;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            this.numBodies = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            System.out.printf("Two arguments are needed: iterations size", new Object[0]);
        } else {
            this.iterations = 51;
            this.numBodies = 16384;
        }
    }

    @Override
    protected String getName() {
        return "nbody";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d", this.getName(), this.iterations, this.numBodies);
    }

    @Override
    protected String getConfigString() {
        return String.format("size=%d", this.numBodies);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new NBodyJava(this.numBodies, this.iterations);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new NBodyTornado(this.numBodies, this.iterations);
    }
}

