/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.montecarlo;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class MonteCarloTornado
extends BenchmarkDriver {
    private FloatArray output;
    private int size;

    public MonteCarloTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.output = new FloatArray(this.size);
        this.taskGraph = new TaskGraph("benchmark").task("montecarlo", ComputeKernels::monteCarlo, (Object)this.output, (Object)this.size).transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.output = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean isCorrect = true;
        FloatArray result = new FloatArray(this.size);
        ComputeKernels.monteCarlo(result, this.size);
        this.executionPlan.withDevice(device).execute();
        this.executionPlan.clearProfiles();
        for (int i = 0; i < this.size; ++i) {
            if (!((double)TornadoMath.abs((float)(this.output.get(i) - result.get(i))) > 0.01)) continue;
            isCorrect = false;
            break;
        }
        System.out.printf("Number validation: " + isCorrect + "\n", new Object[0]);
        return isCorrect;
    }
}

