/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.montecarlo;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class MonteCarloJava
extends BenchmarkDriver {
    private final int size;
    private FloatArray seq;

    public MonteCarloJava(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.seq = new FloatArray(this.size);
    }

    @Override
    public void tearDown() {
        this.seq = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.monteCarlo(this.seq, this.size);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

