/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.montecarlo;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.montecarlo.MonteCarloJava;
import uk.ac.manchester.tornado.benchmarks.montecarlo.MonteCarloTornado;

public class Benchmark
extends BenchmarkRunner {
    private int size;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            this.size = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            System.out.println("Two arguments are needed: iterations size");
            System.exit(0);
        } else {
            this.iterations = 41;
            this.size = 8192;
        }
    }

    @Override
    protected String getName() {
        return "montecarlo";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d", this.getName(), this.iterations, this.size);
    }

    @Override
    protected String getConfigString() {
        return String.format("size=%d", this.size);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new MonteCarloJava(this.iterations, this.size);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new MonteCarloTornado(this.iterations, this.size);
    }
}

