/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.mandelbrot;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class MandelbrotTornado
extends BenchmarkDriver {
    int size;
    ShortArray output;

    public MandelbrotTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.output = new ShortArray(this.size * this.size);
        this.taskGraph = new TaskGraph("benchmark").task("t0", ComputeKernels::mandelbrot, (Object)this.size, (Object)this.output).transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.output = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean val = true;
        ShortArray result = new ShortArray(this.size * this.size);
        this.executionPlan.withDevice(device).execute();
        this.executionPlan.clearProfiles();
        ComputeKernels.mandelbrot(this.size, result);
        block0: for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!((double)Math.abs(this.output.get(i * this.size + j) - result.get(i * this.size + j)) > 0.01)) continue;
                val = false;
                continue block0;
            }
        }
        System.out.printf("Number validation: " + val + "\n", new Object[0]);
        return val;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

